/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmgradleplugin;

import com.anaplan.engineering.vdmgradleplugin.VdmGradlePluginKt;
import com.anaplan.engineering.vdmgradleplugin.ZipContents;
import java.io.File;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"vdmManifestDir", "Ljava/io/File;", "Lorg/gradle/api/Project;", "getVdmManifestDir", "(Lorg/gradle/api/Project;)Ljava/io/File;", "createManifest", "", "type", "createManifestFile", "createManifestForZip", "Lcom/anaplan/engineering/vdmgradleplugin/ZipContents;", "vdm-gradle-plugin"})
public final class ManifestCreatorKt {
    private static final File getVdmManifestDir(Project $this$vdmManifestDir) {
        return new File(VdmGradlePluginKt.getVdmBuildDir($this$vdmManifestDir), "manifests");
    }

    private static final File createManifestFile(Project $this$createManifestFile, String type) {
        File manifestFile = new File(ManifestCreatorKt.getVdmManifestDir($this$createManifestFile), "manifest-" + type + ".mf");
        if (!manifestFile.getParentFile().exists()) {
            manifestFile.getParentFile().mkdirs();
        }
        FilesKt.writeText$default((File)manifestFile, (String)ManifestCreatorKt.createManifest($this$createManifestFile, type), null, (int)2, null);
        return manifestFile;
    }

    private static final String createManifest(Project $this$createManifest, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append("Group: " + $this$createManifest.getGroup() + '\n');
        sb.append("Name: " + $this$createManifest.getName() + '\n');
        sb.append("Version: " + $this$createManifest.getVersion() + '\n');
        sb.append("Type: " + type + '\n');
        sb.append("Built: " + LocalDateTime.now() + '\n');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final ZipContents createManifestForZip(@NotNull Project $this$createManifestForZip, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)$this$createManifestForZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Project project = $this$createManifestForZip.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return new ZipContents(CollectionsKt.listOf((Object)ManifestCreatorKt.createManifestFile(project, type)), CollectionsKt.listOf((Object)new File("manifest.mf")), null, 4, null);
    }
}

