/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmgradleplugin;

import com.anaplan.engineering.vdmgradleplugin.ExpectedTestResult;
import com.anaplan.engineering.vdmgradleplugin.Logger;
import com.anaplan.engineering.vdmgradleplugin.OvertureWrapperKt;
import com.anaplan.engineering.vdmgradleplugin.TestResult;
import com.anaplan.engineering.vdmgradleplugin.TestResultState;
import com.anaplan.engineering.vdmgradleplugin.TestSuite;
import com.anaplan.engineering.vdmgradleplugin.TestSuiteResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.overture.interpreter.runtime.ContextException;
import org.overture.interpreter.runtime.Interpreter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0007\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/anaplan/engineering/vdmgradleplugin/TestRunner;", "", "interpreter", "Lorg/overture/interpreter/runtime/Interpreter;", "logger", "Lcom/anaplan/engineering/vdmgradleplugin/Logger;", "(Lorg/overture/interpreter/runtime/Interpreter;Lcom/anaplan/engineering/vdmgradleplugin/Logger;)V", "run", "Lcom/anaplan/engineering/vdmgradleplugin/TestSuiteResult;", "testSuite", "Lcom/anaplan/engineering/vdmgradleplugin/TestSuite;", "timestamp", "Ljava/time/LocalDateTime;", "Lcom/anaplan/engineering/vdmgradleplugin/TestResult;", "moduleName", "", "testName", "", "testSuites", "vdm-gradle-plugin"})
final class TestRunner {
    @NotNull
    private final Interpreter interpreter;
    @NotNull
    private final Logger logger;

    public TestRunner(@NotNull Interpreter interpreter, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.interpreter = interpreter;
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestSuiteResult> run(@NotNull List<TestSuite> testSuites) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(testSuites, (String)"testSuites");
        this.interpreter.init(null);
        LocalDateTime timestamp = LocalDateTime.now();
        Iterable $this$map$iv = testSuites;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestSuite testSuite = (TestSuite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"timestamp");
            TestSuiteResult testSuiteResult = this.run((TestSuite)it, timestamp);
            collection.add(testSuiteResult);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final TestSuiteResult run(TestSuite testSuite, LocalDateTime timestamp) {
        void $this$mapTo$iv$iv;
        this.interpreter.setDefaultName(testSuite.getModuleName());
        Iterable $this$map$iv = testSuite.getTestNames();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TestResult testResult = this.run(testSuite.getModuleName(), (String)it);
            collection.add(testResult);
        }
        List testResults = (List)destination$iv$iv;
        return new TestSuiteResult(testSuite.getModuleName(), timestamp, testResults);
    }

    private final TestResult run(String moduleName, String testName) {
        TestResult testResult;
        ExpectedTestResult expectedResult = OvertureWrapperKt.access$getExpectedResult(testName);
        long start = System.currentTimeMillis();
        try {
            TestResult testResult2;
            this.interpreter.execute(Intrinsics.stringPlus((String)testName, (Object)"()"), null);
            long duration2 = System.currentTimeMillis() - start;
            if (expectedResult == ExpectedTestResult.success) {
                this.logger.debug("PASS .. " + moduleName + '`' + testName);
                testResult2 = new TestResult(testName, duration2, TestResultState.PASS, null, 8, null);
            } else {
                String msg = Intrinsics.stringPlus((String)"test passed, but expected ", (Object)expectedResult.getDescription());
                this.logger.info("FAIL .. " + moduleName + '`' + testName + " -- " + msg);
                testResult2 = new TestResult(testName, duration2, TestResultState.FAIL, msg);
            }
            testResult = testResult2;
        }
        catch (ContextException e) {
            TestResult testResult3;
            long duration3 = System.currentTimeMillis() - start;
            if (OvertureWrapperKt.access$getPostconditionFailureCodes$p().contains(e.number)) {
                if (expectedResult == ExpectedTestResult.failedPostcondition) {
                    this.logger.debug("PASS .. " + moduleName + '`' + testName);
                    testResult3 = new TestResult(testName, duration3, TestResultState.PASS, null, 8, null);
                } else {
                    this.logger.info("FAIL .. " + moduleName + '`' + testName);
                    testResult3 = new TestResult(testName, duration3, TestResultState.FAIL, e.getMessage());
                }
            } else if (OvertureWrapperKt.access$getPreconditionFailureCodes$p().contains(e.number) && expectedResult == ExpectedTestResult.failedPrecondition) {
                this.logger.debug("PASS .. " + moduleName + '`' + testName);
                testResult3 = new TestResult(testName, duration3, TestResultState.PASS, null, 8, null);
            } else if (OvertureWrapperKt.access$getInvariantFailureCodes$p().contains(e.number) && expectedResult == ExpectedTestResult.failedInvariant) {
                this.logger.debug("PASS .. " + moduleName + '`' + testName);
                testResult3 = new TestResult(testName, duration3, TestResultState.PASS, null, 8, null);
            } else {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.write("\nERROR .. " + moduleName + '`' + testName + '\n' + e.getMessage() + '\n');
                e.ctxt.printStackTrace(printWriter, true);
                String string = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringWriter.toString()");
                this.logger.error(string);
                testResult3 = new TestResult(testName, duration3, TestResultState.ERROR, e.getMessage());
            }
            testResult = testResult3;
        }
        return testResult;
    }
}

