/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.engineering.vdmgradleplugin;

import com.anaplan.engineering.vdmgradleplugin.LogAndSaveOutputStream;
import com.anaplan.engineering.vdmgradleplugin.OvertureTask;
import com.anaplan.engineering.vdmgradleplugin.VdmGradlePluginKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/anaplan/engineering/vdmgradleplugin/VdmTypeCheckTask;", "Lcom/anaplan/engineering/vdmgradleplugin/OvertureTask;", "includeTests", "", "(Z)V", "logFile", "Ljava/io/File;", "getLogFile", "()Ljava/io/File;", "specificationFiles", "Lorg/gradle/api/file/FileCollection;", "getSpecificationFiles", "()Lorg/gradle/api/file/FileCollection;", "clearLogFile", "", "constructArgs", "", "", "kotlin.jvm.PlatformType", "exec", "log", "line", "", "vdm-gradle-plugin"})
public class VdmTypeCheckTask
extends OvertureTask {
    private final boolean includeTests;

    public VdmTypeCheckTask(boolean includeTests) {
        this.includeTests = includeTests;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final FileCollection getSpecificationFiles() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurableFileCollection configurableFileCollection = VdmGradlePluginKt.locateAllSpecifications(project, this.getDialect(), this.includeTests);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.locateAllSpecifi\u2026ns(dialect, includeTests)");
        return (FileCollection)configurableFileCollection;
    }

    @OutputFile
    @NotNull
    public final File getLogFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return new File(VdmGradlePluginKt.getVdmBuildDir(project), "typeCheckTask.log");
    }

    public void exec() {
        this.getLogger().info(Intrinsics.stringPlus((String)"VDM dialect: ", (Object)((Object)this.getDialect())));
        if (this.getSpecificationFiles().isEmpty()) {
            this.getLogger().info("No files found");
        } else {
            this.clearLogFile();
            this.setStandardOutput(new LogAndSaveOutputStream(this.getLogFile(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ VdmTypeCheckTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    VdmTypeCheckTask.access$log(this.this$0, it);
                }
            })));
            Object[] objectArray = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project");
            this.setJvmArgs(VdmGradlePluginKt.getVdmConfig((Project)objectArray).getOvertureJvmArgs());
            this.setArgs(this.constructArgs());
            objectArray = new Object[]{this.createClassPathJar()};
            this.setClasspath((FileCollection)this.getProject().files(objectArray));
            super.exec();
        }
    }

    private final void log(String line) {
        LogLevel level = StringsKt.startsWith$default((String)line, (String)"Error", (boolean)false, (int)2, null) ? LogLevel.ERROR : (StringsKt.startsWith$default((String)line, (String)"Warning", (boolean)false, (int)2, null) ? LogLevel.WARN : (StringsKt.startsWith$default((String)line, (String)"Parsed", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"Type checked", (boolean)false, (int)2, null) ? LogLevel.INFO : LogLevel.LIFECYCLE));
        this.getLogger().log(level, line);
    }

    private final void clearLogFile() {
        this.getLogFile().delete();
        this.getLogFile().createNewFile();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> constructArgs() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Object[8];
        object[0] = "--dialect";
        object[1] = this.getDialect().name();
        object[2] = "--log-level";
        object[3] = this.getProject().getGradle().getStartParameter().getLogLevel();
        object[4] = "--run-tests";
        object[5] = false;
        object[6] = "--monitor-memory";
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        object[7] = VdmGradlePluginKt.getVdmConfig(project).getMonitorOvertureMemory();
        Collection collection2 = CollectionsKt.listOf((Object[])object);
        object = (Iterable)this.getSpecificationFiles();
        Collection collection3 = collection2;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection3, (Iterable)collection);
    }

    public static final /* synthetic */ void access$log(VdmTypeCheckTask $this, String line) {
        $this.log(line);
    }
}

