/*
 * Decompiled with CFR 0.152.
 */
package com.kheera.executor;

import android.os.Build;
import android.support.test.InstrumentationRegistry;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.kheera.annotations.RetainAcrossTests;
import com.kheera.annotations.TestModule;
import com.kheera.annotations.TestStep;
import com.kheera.internal.AssetUtils;
import com.kheera.internal.AutomationRunnerException;
import com.kheera.internal.OnFinishMethodMappingEntry;
import com.kheera.internal.OnStartMethodMappingEntry;
import com.kheera.internal.StepDefFunctionTable;
import com.kheera.internal.StepDefinition;
import com.kheera.internal.TestRunnerConfig;
import com.kheera.internal.TestStepMappingEntry;
import com.kheera.utils.StringUtils;
import gherkin.AstBuilder;
import gherkin.GherkinDialectProvider;
import gherkin.Parser;
import gherkin.TableConverter;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.Argument;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class FeatureFileExecutor
extends Runner {
    private final Class<?> testClass;
    private final TestRunnerConfig runnerConfig;
    private static final String GERKIN_DIALECT = "en";
    private final Compiler pickleCompiler;
    private final Parser<GherkinDocument> gherkinParser;
    private JsonElement testData;

    public FeatureFileExecutor(TestRunnerConfig configData, Class<?> testClass) throws AutomationRunnerException {
        this.testClass = testClass;
        this.runnerConfig = configData;
        GherkinDialectProvider gherkinDialect = new GherkinDialectProvider(GERKIN_DIALECT, AssetUtils.ReadAsset(InstrumentationRegistry.getContext(), "gherkin-languages.json"));
        this.gherkinParser = new Parser<GherkinDocument>(gherkinDialect, new AstBuilder());
        this.pickleCompiler = new Compiler();
    }

    public Description getDescription() {
        return Description.createSuiteDescription(this.testClass);
    }

    public void run(RunNotifier notifier) {
        try {
            String fileContent;
            if (!StringUtils.isEmpty(this.runnerConfig.TestDataFile)) {
                String fullPath = "config" + File.separator;
                fullPath = this.runnerConfig.TestDataFile.contains("/") ? fullPath + this.runnerConfig.TestDataFile : fullPath + this.runnerConfig.Name.toLowerCase(Locale.getDefault()) + File.separator + this.runnerConfig.TestDataFile;
                this.testData = new JsonParser().parse(AssetUtils.ReadAsset(InstrumentationRegistry.getContext(), fullPath));
            }
            String featureFilename = null;
            if (this.testClass.isAnnotationPresent(TestModule.class)) {
                featureFilename = "features" + File.separator + this.testClass.getAnnotation(TestModule.class).featureFile();
                fileContent = AssetUtils.ReadAsset(InstrumentationRegistry.getContext(), featureFilename);
                if (fileContent == null) {
                    throw new AutomationRunnerException("Unable to read the feature file: " + featureFilename, null);
                }
            } else {
                throw new AutomationRunnerException("Feature file implementation class is missing annotation: " + featureFilename, null);
            }
            StepDefinition featureFileInstance = (StepDefinition)this.testClass.newInstance();
            featureFileInstance.onCreate(InstrumentationRegistry.getContext(), this.runnerConfig);
            StepDefFunctionTable featureFileMethodIndex = new StepDefFunctionTable(InstrumentationRegistry.getContext(), featureFileInstance);
            GherkinDocument gherkinDocument = this.gherkinParser.parse(fileContent);
            List<Pickle> pickles = this.pickleCompiler.compile(gherkinDocument, featureFilename);
            Feature feature = gherkinDocument.getFeature();
            boolean successful = this.executeFeature(featureFilename, feature, pickles, featureFileInstance, featureFileMethodIndex, notifier);
            pickles.clear();
            this.cleanup(featureFileInstance);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (AutomationRunnerException e) {
            e.printStackTrace();
        }
    }

    private void cleanup(StepDefinition featureFileInstance) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = featureFileInstance.getClass().getDeclaredFields()) {
            if (field.getType().isPrimitive() || field.isAnnotationPresent(RetainAcrossTests.class) || (field.getModifiers() & 0x10) != 0) continue;
            try {
                field.setAccessible(true);
                field.set(featureFileInstance, null);
            }
            catch (Exception e) {
                Log.d((String)"TestCase", (String)"Error: Could not nullify field!");
            }
            if (field.get(featureFileInstance) == null) continue;
            Log.d((String)"TestCase", (String)"Error: Could not nullify field!");
        }
    }

    private boolean executeFeature(String featureFilename, Feature featureFileModel, List<Pickle> pickles, StepDefinition stepDefinition, StepDefFunctionTable stepDefinitionFunctionTable, RunNotifier notifier) throws AutomationRunnerException {
        ArrayList failingTests = new ArrayList();
        ArrayList skippedTests = new ArrayList();
        ArrayList passingTests = new ArrayList();
        Pattern pattern = null;
        Matcher matcher = null;
        this.applyScenarioFilters(pickles);
        this.applyTagFilters(pickles);
        this.applySkipFilters(pickles);
        int numberOfTests = pickles.size();
        boolean allSuccessful = true;
        for (Pickle pickle : pickles) {
            Set<OnFinishMethodMappingEntry> finishMethods;
            Description testDescription = Description.createTestDescription((String)featureFileModel.getName(), (String)pickle.getName(), null);
            String errorDescription = "";
            boolean errorEncountered = false;
            Log.d((String)this.runnerConfig.LogTag, (String)String.format("started: %s(%s)", pickle.getName(), featureFileModel.getName()));
            notifier.fireTestStarted(testDescription);
            StringBuffer pickleDescriptionBuffer = new StringBuffer();
            for (PickleStep step : pickle.getSteps()) {
                pickleDescriptionBuffer.append("\t" + step.getVerb().toUpperCase(Locale.getDefault()) + " " + step.getText().replace("\r", " ").replace("\n", " ").replace("  ", " ").trim());
                pickleDescriptionBuffer.append("\r\n");
            }
            String pickleInstanceDescription = pickleDescriptionBuffer.toString();
            Set<OnStartMethodMappingEntry> setUpMethods = stepDefinitionFunctionTable.findSetUpMethods(pickle);
            if (setUpMethods != null) {
                for (OnStartMethodMappingEntry m : setUpMethods) {
                    Method setUpMethod = m.methodReference;
                    try {
                        if (setUpMethod.getParameterTypes().length == 0) {
                            setUpMethod.invoke(m.declaringObject, new Object[0]);
                            continue;
                        }
                        Object[] args = new Object[]{featureFileModel.getName(), pickle.getName()};
                        setUpMethod.invoke(m.declaringObject, args);
                    }
                    catch (Throwable e) {
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        errorDescription = "Feature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, "0") + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescription + "\r\n\r\nReason: Failed to execute onStartTest method.";
                        errorEncountered = true;
                        notifier.fireTestFailure(new Failure(Description.createTestDescription((String)featureFileModel.getName(), (String)"onStartTest", null), (Throwable)new AutomationRunnerException(errorDescription, e)));
                    }
                }
                setUpMethods.clear();
            }
            if (!errorEncountered && pickle.getSteps() != null && pickle.getSteps().size() > 0) {
                for (PickleStep step : pickle.getSteps()) {
                    int stepLine = 0;
                    boolean methodCalled = false;
                    if (step.getLocations() != null && step.getLocations().size() >= 1) {
                        stepLine = step.getLocations().get(0).getLine();
                    }
                    StringBuffer pickleInstanceDescriptionDetailedBuilder = new StringBuffer();
                    for (PickleStep s : pickle.getSteps()) {
                        pickleInstanceDescriptionDetailedBuilder.append(("->" + s.getVerb().toUpperCase(Locale.getDefault()) + " " + s.getText() + (s.equals(step) ? " <-- FAILED" : "")).replace("\r", " ").replace("\n", " "));
                        pickleInstanceDescriptionDetailedBuilder.append("\r\n");
                    }
                    String pickleInstanceDescriptionDetailed = pickleInstanceDescriptionDetailedBuilder.toString();
                    TestStepMappingEntry mapEntry = stepDefinitionFunctionTable.findMatchingMethod(step.getText());
                    if (mapEntry != null) {
                        Method m;
                        block33: {
                            m = mapEntry.methodReference;
                            if (m == null) {
                                String failureString = "Feature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, stepLine) + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescription + "\r\n\r\nLine: " + step.getLocations().get(0).getLine() + "\r\nReason: Failed to find an implementation for the scenario step.\r\nDetails:\r\n\r\nStep: " + step.getText();
                                notifier.fireTestFailure(new Failure(testDescription, (Throwable)new AutomationRunnerException(failureString, null)));
                                allSuccessful = false;
                                errorEncountered = true;
                                break;
                            }
                            if (!errorEncountered) {
                                try {
                                    m.setAccessible(true);
                                    String exp = m.getAnnotation(TestStep.class).value();
                                    String stringExpression = step.getText();
                                    if (stringExpression.matches(exp)) {
                                        pattern = Pattern.compile(exp);
                                        matcher = pattern.matcher(stringExpression);
                                        ArrayList<Object> parameters = new ArrayList<Object>();
                                        if (matcher.matches() && matcher.groupCount() > 0) {
                                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                                String text = matcher.group(i);
                                                parameters.add(text);
                                            }
                                            this.translateScenarioArguments(parameters);
                                        }
                                        if (step.getArgument() != null && step.getArgument().size() > 0) {
                                            for (Argument arg : step.getArgument()) {
                                                if (!(arg instanceof PickleTable)) continue;
                                                Type[] parameterTypes = m.getGenericParameterTypes();
                                                PickleTable tbl = (PickleTable)arg;
                                                if (tbl.getRows() == null || tbl.getRows().size() < 1 || parameterTypes.length <= 0) continue;
                                                Object p = TableConverter.convert(tbl, parameterTypes[parameterTypes.length - 1], this.testData);
                                                parameters.add(p);
                                            }
                                        }
                                        Object[] args = parameters.toArray(new Object[0]);
                                        if (mapEntry != null && mapEntry.declaringObject != null && m != null) {
                                            pickleInstanceDescriptionDetailed = pickleInstanceDescriptionDetailed.replace("<-- FAILED", "<-- FAILED ( Step Def: " + mapEntry.declaringObject.getClass().getSimpleName() + "::" + m.getName() + "() )");
                                        }
                                        m.invoke(mapEntry.declaringObject, args);
                                        methodCalled = true;
                                        parameters.clear();
                                    }
                                    if (!methodCalled) {
                                        String failureString = "Feature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, stepLine) + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescription + "\r\n\r\nLine: " + step.getLocations().get(0).getLine() + "\r\nReason: No method for calling the implementation was found.\r\nDetails:\r\n\r\nStep: " + step.getText();
                                        notifier.fireTestFailure(new Failure(testDescription, (Throwable)new AutomationRunnerException(failureString, null)));
                                        errorEncountered = true;
                                    }
                                    break block33;
                                }
                                catch (Throwable e) {
                                    if (e instanceof InvocationTargetException) {
                                        e = ((InvocationTargetException)e).getTargetException();
                                    }
                                    e.printStackTrace();
                                    errorDescription = "Device: " + String.format("%s %s %s", Build.MANUFACTURER, Build.BRAND, Build.MODEL) + "\r\nFeature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, stepLine) + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescriptionDetailed + "\r\n\r\nReason: " + (this.runnerConfig.DetailedErrors ? e.getMessage() + "\r\n\r\n" + FeatureFileExecutor.getStackTraceString(e.getStackTrace()) : e.getMessage()) + "\r\n";
                                    if (e instanceof AssumptionViolatedException) {
                                        notifier.fireTestAssumptionFailed(new Failure(Description.createTestDescription((String)featureFileModel.getName(), (String)pickle.getName(), null), (Throwable)new AutomationRunnerException(errorDescription, null)));
                                        break;
                                    }
                                    errorEncountered = true;
                                    notifier.fireTestFailure(new Failure(testDescription, (Throwable)new AutomationRunnerException(errorDescription, null)));
                                    if (!this.runnerConfig.Screenshots) break;
                                    try {
                                        String tag = step.getText().replaceAll("[\"!@#$%-+^&*(),.;'\u2019?~`\n]", "_").replace("\\n", "_").replace(" ", "_").replace(":", "");
                                        String testclassName = featureFileModel.getName();
                                        String testMethodName = pickle.getName();
                                        this.onTakeScreenshot(null, tag, testclassName, testMethodName);
                                    }
                                    catch (Exception exception) {}
                                }
                                break;
                            }
                        }
                        m = null;
                        continue;
                    }
                    errorDescription = "Device: " + String.format("%s %s %s", Build.MANUFACTURER, Build.BRAND, Build.MODEL) + "\r\nFeature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, stepLine) + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescriptionDetailed + "\r\n\r\nReason: Failed to find an implementation for the scenario step.\r\nDetails:\r\n\r\nStep: " + step.getText();
                    notifier.fireTestFailure(new Failure(Description.createTestDescription((String)featureFileModel.getName(), (String)pickle.getName(), null), (Throwable)new AutomationRunnerException(errorDescription, null)));
                    errorEncountered = true;
                    allSuccessful = false;
                    break;
                }
            }
            if ((finishMethods = stepDefinitionFunctionTable.findOnFinishMethod(pickle)) != null) {
                for (OnFinishMethodMappingEntry m : finishMethods) {
                    Method finishMethod = m.methodReference;
                    try {
                        if (finishMethod.getParameterTypes().length == 0) {
                            finishMethod.invoke(m.declaringObject, new Object[0]);
                            continue;
                        }
                        Object[] args = new Object[]{featureFileModel.getName(), pickle.getName()};
                        finishMethod.invoke(m.declaringObject, args);
                    }
                    catch (Exception e) {
                        errorDescription = "Feature: " + featureFileModel.getName() + "\r\nFile: " + String.format("%s (Line %s)", featureFilename, "0") + "\r\nScenario: " + pickle.getName() + "\r\nSteps: \r\n" + pickleInstanceDescription + "\r\n\r\nReason: Failed to find/call onFinish method.";
                        errorEncountered = true;
                        notifier.fireTestFailure(new Failure(Description.createTestDescription((String)featureFileModel.getName(), (String)"onFinishTest", null), (Throwable)new AutomationRunnerException(errorDescription, e)));
                        allSuccessful = false;
                        break;
                    }
                }
            }
            finishMethods.clear();
            Log.d((String)this.runnerConfig.LogTag, (String)String.format("finished: %s(%s)", pickle.getName(), featureFileModel.getName()));
            notifier.fireTestFinished(testDescription);
        }
        return allSuccessful;
    }

    private void onTakeScreenshot(Object o, String tag, String testclassName, String testMethodName) {
    }

    private void applyScenarioFilters(List<Pickle> pickles) {
        if (this.runnerConfig.FilterType != null && this.runnerConfig.FilterType.equals("scenario") && !StringUtils.isEmpty(this.runnerConfig.FilterBy)) {
            ArrayList<Pickle> filteredPickles = new ArrayList<Pickle>();
            for (Pickle pickle : pickles) {
                String scenarioName = pickle.getName().toLowerCase();
                boolean matchesTag = false;
                matchesTag = this.runnerConfig.FilterBy.startsWith("/") && this.runnerConfig.FilterBy.endsWith("/") ? scenarioName.matches(this.runnerConfig.FilterBy.toLowerCase().substring(1, this.runnerConfig.FilterBy.length() - 1)) : scenarioName.contentEquals(this.runnerConfig.FilterBy.toLowerCase());
                if (!matchesTag) continue;
                filteredPickles.add(pickle);
            }
            pickles.clear();
            if (!filteredPickles.isEmpty()) {
                pickles.addAll(filteredPickles);
            }
            filteredPickles.clear();
            Object var2_2 = null;
        }
    }

    private void translateScenarioArguments(List<Object> parameters) {
        if (this.testData != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                String[] pathElements;
                String raw;
                if (!(parameters.get(i) instanceof String) || !(raw = (String)parameters.get(i)).startsWith("$(") || !raw.endsWith(")") || (pathElements = (raw = raw.substring("$(".length(), raw.length() - ")".length())).split("\\.")) == null || pathElements.length <= 0) continue;
                JsonElement elemPointer = this.testData;
                for (String element : pathElements) {
                    if (!elemPointer.isJsonObject() || !elemPointer.getAsJsonObject().has(element)) {
                        elemPointer = null;
                        break;
                    }
                    elemPointer = elemPointer.getAsJsonObject().get(element);
                }
                if (elemPointer == null || !elemPointer.isJsonPrimitive()) continue;
                JsonPrimitive primitive = elemPointer.getAsJsonPrimitive();
                if (primitive.isString() || primitive.isNumber()) {
                    parameters.set(i, primitive.getAsString());
                    continue;
                }
                if (!primitive.isBoolean()) continue;
                parameters.set(i, primitive.getAsBoolean());
            }
        }
    }

    private String getPickleId(Pickle pickle) {
        StringBuffer sb = new StringBuffer();
        sb.append(pickle.getName() + "\n");
        for (PickleStep s : pickle.getSteps()) {
            sb.append(("->" + s.getVerb().toUpperCase(Locale.getDefault()) + " " + s.getText()).replace("\r", " ").replace("\n", " "));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static String getStackTraceString(StackTraceElement[] elements) {
        StringBuffer sb = new StringBuffer();
        if (elements != null && elements.length > 0) {
            for (StackTraceElement element : elements) {
                sb.append(element.toString() + "\r\n");
            }
        }
        return sb.toString();
    }

    private void applyTagFilters(List<Pickle> pickles) {
        if (this.runnerConfig.FilterType != null && this.runnerConfig.FilterType.equals("tag") && !StringUtils.isEmpty(this.runnerConfig.FilterBy)) {
            ArrayList<Pickle> filteredPickles = new ArrayList<Pickle>();
            for (Pickle pickle : pickles) {
                if (pickle.getTags() == null || pickle.getTags().size() == 0) continue;
                for (PickleTag tag : pickle.getTags()) {
                    String tagString = tag.getName().toLowerCase(Locale.getDefault());
                    if (tagString.startsWith("@") && tagString.length() > 0) {
                        tagString = tagString.substring(1);
                    }
                    boolean matchesTag = false;
                    matchesTag = this.runnerConfig.FilterBy.startsWith("/") && this.runnerConfig.FilterBy.endsWith("/") ? tagString.matches(this.runnerConfig.FilterBy.toLowerCase(Locale.getDefault()).substring(1, this.runnerConfig.FilterBy.length() - 1)) : tagString.contentEquals(this.runnerConfig.FilterBy.toLowerCase(Locale.getDefault()));
                    if (!matchesTag) continue;
                    filteredPickles.add(pickle);
                }
            }
            pickles.clear();
            if (filteredPickles.size() > 0) {
                pickles.addAll(filteredPickles);
            }
            filteredPickles.clear();
            Object var2_2 = null;
        }
    }

    private void applySkipFilters(List<Pickle> pickles) {
        Pattern paramMatchPattern = Pattern.compile("(\\w+)=([^\\s,()]+)", 2);
        if (!this.runnerConfig.IncludeSkipped) {
            ArrayList<Pickle> skippedPickles = new ArrayList<Pickle>();
            for (Pickle pickle : pickles) {
                if (pickle.getTags() == null || pickle.getTags().size() == 0) continue;
                for (PickleTag tag : pickle.getTags()) {
                    String tagText = tag.getName().toLowerCase(Locale.getDefault());
                    if (!tagText.startsWith("@ignore") && !tagText.startsWith("@skip") && !tagText.startsWith("@disable") && !tagText.startsWith("@filter") && !tagText.startsWith("@note")) continue;
                    Matcher paramsMatcher = paramMatchPattern.matcher(tagText);
                    boolean willIgnore = true;
                    if (tagText.startsWith("@note")) continue;
                    while (paramsMatcher.find()) {
                        int groupCount = paramsMatcher.groupCount();
                        if (groupCount >= 1) {
                            willIgnore = false;
                        }
                        if (groupCount != 2) continue;
                        String key = paramsMatcher.group(1);
                        String value = paramsMatcher.group(2);
                        if ((key.toLowerCase(Locale.getDefault()).equals("maxsdkversion") || key.toLowerCase(Locale.getDefault()).equals("maxsdk")) && Integer.parseInt(value) <= Build.VERSION.SDK_INT) {
                            willIgnore = true;
                        }
                        if (!key.toLowerCase(Locale.getDefault()).equals("minsdkversion") && !key.toLowerCase(Locale.getDefault()).equals("minsdk") || Integer.parseInt(value) < Build.VERSION.SDK_INT) continue;
                        willIgnore = true;
                    }
                    if (!willIgnore) continue;
                    skippedPickles.add(pickle);
                }
            }
            for (Pickle pickle : skippedPickles) {
                pickles.remove(pickle);
            }
            skippedPickles.clear();
        }
    }
}

