/*
 * Decompiled with CFR 0.152.
 */
package com.kheera.internal;

import android.content.Context;
import com.kheera.internal.AutomationRunnerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AssetUtils {
    public static String ReadAsset(Context context, String filename) throws AutomationRunnerException {
        BufferedReader in = null;
        try {
            String str;
            StringBuilder buf = new StringBuilder();
            InputStream is = context.getAssets().open(filename);
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            boolean isFirst = true;
            while ((str = in.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('\n');
                }
                buf.append(str);
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException e) {
            throw new AutomationRunnerException("Error opening asset: " + filename, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new AutomationRunnerException("Error closing asset: " + filename, e);
                }
            }
        }
    }

    public static String[] List(Context context, String path) throws IOException {
        return context.getAssets().list(path);
    }
}

