/*
 * Decompiled with CFR 0.152.
 */
package com.kheera.internal;

import android.content.Context;
import android.support.test.InstrumentationRegistry;
import com.kheera.annotations.OnFinishTest;
import com.kheera.annotations.OnStartTest;
import com.kheera.annotations.RootTestModule;
import com.kheera.annotations.TestModule;
import com.kheera.annotations.TestStep;
import com.kheera.internal.AutomationRunnerException;
import com.kheera.internal.Benchmarker;
import com.kheera.internal.OnFinishMethodMappingEntry;
import com.kheera.internal.OnStartMethodMappingEntry;
import com.kheera.internal.StepDefinition;
import com.kheera.internal.TestStepMappingEntry;
import dalvik.system.DexFile;
import gherkin.pickles.Pickle;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class StepDefFunctionTable {
    private final HashSet<OnStartMethodMappingEntry> declaredBeforeMethods;
    private final HashMap<String, TestStepMappingEntry> declaredTestStepMethods;
    private final HashSet<OnFinishMethodMappingEntry> declaredFinishMethods;
    private final HashMap<String, TestStepMappingEntry> expressionCache;
    private final Context context;
    private final Class<? extends StepDefinition> stepDefClass;
    private final StepDefinition stepDefObject;
    private boolean enableExpressionCache = true;

    public StepDefFunctionTable(Context context, StepDefinition stepDef) throws AutomationRunnerException {
        this.context = context;
        this.stepDefClass = stepDef.getClass();
        this.stepDefObject = stepDef;
        this.declaredBeforeMethods = new HashSet();
        this.declaredTestStepMethods = new HashMap();
        this.declaredFinishMethods = new HashSet();
        this.expressionCache = new HashMap();
        if (this.stepDefClass != null) {
            this.indexStepDefClass();
        }
    }

    private void indexStepDefClass() throws AutomationRunnerException {
        this.indexStepsOnModule(this.stepDefObject);
    }

    public Set<OnFinishMethodMappingEntry> findOnFinishMethod(Pickle pickle) {
        Benchmarker.start("findOnFinishMethod");
        HashSet<OnFinishMethodMappingEntry> method = new HashSet<OnFinishMethodMappingEntry>();
        String featureName = pickle.getName();
        for (OnFinishMethodMappingEntry m : this.declaredFinishMethods) {
            if (m.condition != null) {
                // empty if block
            }
            method.add(m);
        }
        Benchmarker.stop();
        return method;
    }

    public Set<OnStartMethodMappingEntry> findSetUpMethods(Pickle pickle) {
        Benchmarker.start("findSetUpMethod");
        HashSet<OnStartMethodMappingEntry> method = new HashSet<OnStartMethodMappingEntry>();
        String featureName = pickle.getName();
        for (OnStartMethodMappingEntry m : this.declaredBeforeMethods) {
            if (m.condition != null) {
                // empty if block
            }
            method.add(m);
        }
        Benchmarker.stop();
        return method;
    }

    public TestStepMappingEntry findMatchingMethod(String expression) {
        Benchmarker.start("findMatchingMethod: " + expression);
        if (this.enableExpressionCache && this.expressionCache.containsKey(expression)) {
            Benchmarker.stop();
            return this.expressionCache.get(expression);
        }
        for (TestStepMappingEntry entry : this.declaredTestStepMethods.values()) {
            if (!expression.matches(entry.expression)) continue;
            if (this.enableExpressionCache && !this.expressionCache.containsKey(expression)) {
                this.expressionCache.put(expression, entry);
            }
            Benchmarker.stop();
            return entry;
        }
        Benchmarker.stop();
        return null;
    }

    private void indexStepsOnModule(Object declaringObject) throws AutomationRunnerException {
        Field[] fieldArray;
        Method methodRef;
        Benchmarker.start("indexStepsOnModule");
        Set<Method> annotatedTestSteps = this.getMethodsAnnotatedWith(declaringObject, TestStep.class);
        for (Method method : annotatedTestSteps) {
            String string = method.getAnnotation(TestStep.class).value();
            methodRef = method;
            TestStepMappingEntry testMethodMap = new TestStepMappingEntry(string, declaringObject, methodRef);
            this.declaredTestStepMethods.put(string, testMethodMap);
        }
        Set<Method> beforeClasses = this.getMethodsAnnotatedWith(declaringObject, OnStartTest.class);
        for (Method method : beforeClasses) {
            method.setAccessible(true);
            methodRef = method;
            String conditions = "";
            if (method.getAnnotation(OnStartTest.class).condition() != null) {
                conditions = method.getAnnotation(OnStartTest.class).condition();
            }
            OnStartMethodMappingEntry entry = new OnStartMethodMappingEntry(declaringObject, conditions, methodRef);
            this.declaredBeforeMethods.add(entry);
        }
        Set<Method> set = this.getMethodsAnnotatedWith(declaringObject, OnFinishTest.class);
        for (Method m : set) {
            m.setAccessible(true);
            Method methodRef2 = m;
            String conditions = "";
            if (m.getAnnotation(OnFinishTest.class).condition() != null) {
                conditions = m.getAnnotation(OnFinishTest.class).condition();
            }
            OnFinishMethodMappingEntry entry = new OnFinishMethodMappingEntry(declaringObject, conditions, methodRef2);
            this.declaredFinishMethods.add(entry);
        }
        for (Field field : fieldArray = declaringObject.getClass().getFields()) {
            try {
                Class<?> fieldClass;
                if (field.get(declaringObject) == null || !(fieldClass = field.get(declaringObject).getClass()).isAnnotationPresent(TestModule.class)) continue;
                this.indexStepsOnModule(field.get(declaringObject));
            }
            catch (Exception e) {
                if (field.getName() != null) {
                    throw new AutomationRunnerException("Failed indexing gerkin module: " + field.getName(), e);
                }
                throw new AutomationRunnerException("Failed indexing gerkin module.", null);
            }
        }
        Benchmarker.stop();
    }

    private Set<Method> getMethodsAnnotatedWith(Object cl, Class<? extends Annotation> annotation) {
        Method[] methods;
        Benchmarker.start("getMethodsAnnotatedWith");
        LinkedHashSet<Method> retSet = new LinkedHashSet<Method>();
        for (Method m : methods = cl.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            retSet.add(m);
        }
        Benchmarker.stop();
        return retSet;
    }

    private Class findGerkinRoot() throws AutomationRunnerException {
        Benchmarker.start("findGerkinRoot");
        Class<?> c = this.getClass();
        DexFile df = null;
        try {
            df = new DexFile(this.context.getPackageCodePath());
            Enumeration iter = df.entries();
            while (iter.hasMoreElements()) {
                try {
                    Class cl;
                    String s = (String)iter.nextElement();
                    String appPackageName = InstrumentationRegistry.getTargetContext().getPackageName();
                    if (s.startsWith("android.")) continue;
                    if (!s.startsWith(appPackageName) || !(cl = df.loadClass(s, c.getClassLoader())).isAnnotationPresent(RootTestModule.class)) continue;
                    Benchmarker.stop();
                    Class clazz = cl;
                    return clazz;
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            throw new AutomationRunnerException("Error locating gerkin root.", e);
        }
        finally {
            if (df != null) {
                try {
                    df.close();
                }
                catch (IOException iOException) {}
            }
        }
        Benchmarker.stop();
        return null;
    }
}

