/*
 * Decompiled with CFR 0.152.
 */
package com.kheera.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean fileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean delete(String filePath) {
        if (FileUtils.fileExists(filePath)) {
            File file = new File(filePath);
            return file.delete();
        }
        return false;
    }

    public static String readAllText(InputStream stream) throws IOException {
        StringBuilder text = new StringBuilder();
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                text.append(line);
                text.append('\n');
            }
            String string = text.toString();
            return string;
        }
    }

    public static String readAllText(String filename) throws IOException {
        File file = new File(filename);
        StringBuilder text = new StringBuilder();
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = br.readLine()) != null) {
                text.append(line);
                text.append('\n');
            }
            String string = text.toString();
            return string;
        }
    }

    public static void writeAllText(String filename, String content) throws IOException {
        File file = new File(filename);
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bw.write(content);
        }
    }

    public static void createDirectory(String path) {
        File dir = new File(path);
        dir.mkdirs();
    }
}

