/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import com.google.gson.Gson;
import gherkin.GherkinDialect;
import gherkin.IGherkinDialectProvider;
import gherkin.ParserException;
import gherkin.ast.Location;
import java.util.Map;

public class GherkinDialectProvider
implements IGherkinDialectProvider {
    private final String default_dialect_name;
    private Map dialects;

    public void loadDialects(String source) {
        Gson gson = new Gson();
        this.dialects = (Map)gson.fromJson(source, Map.class);
    }

    public GherkinDialectProvider(String default_dialect_name, String dialectFile) {
        this.default_dialect_name = default_dialect_name;
        if (dialectFile != null) {
            this.loadDialects(dialectFile);
        }
    }

    public GherkinDialectProvider() {
        this("en", null);
    }

    @Override
    public GherkinDialect getDefaultDialect() {
        return this.getDialect(this.default_dialect_name, null);
    }

    @Override
    public GherkinDialect getDialect(String language, Location location) {
        Map map = (Map)this.dialects.get(language);
        if (map == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return new GherkinDialect(language, map);
    }
}

