/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.jodamob.reflect.SuperReflect;
import gherkin.CamelCaseStringConverter;
import gherkin.ParserException;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableConverter {
    public static <T> T convert(PickleTable dataTable, Type type, JsonElement testData) {
        if (type == null || type instanceof Class && ((Class)type).isAssignableFrom(PickleTable.class)) {
            return (T)dataTable;
        }
        Type itemType = TableConverter.listItemType(type);
        if (itemType == null) {
            throw new ParserException("Not a List type: " + type);
        }
        Type mapKeyType = TableConverter.mapKeyType(itemType);
        if (mapKeyType != null) {
            Type mapValueType = TableConverter.mapValueType(itemType);
            return (T)TableConverter.toMaps(dataTable);
        }
        Type listitemType = TableConverter.listItemType(itemType);
        if (listitemType != null && ((Class)listitemType).isAssignableFrom(String.class)) {
            return (T)TableConverter.raw(dataTable);
        }
        if (((Class)itemType).isAssignableFrom(String.class)) {
            return (T)TableConverter.toStringList(dataTable, testData);
        }
        return (T)TableConverter.toList(dataTable, itemType, testData);
    }

    public static Type listItemType(Type type) {
        return TableConverter.typeArg(type, List.class, 0);
    }

    public static Type mapKeyType(Type type) {
        return TableConverter.typeArg(type, Map.class, 0);
    }

    public static Type mapValueType(Type type) {
        return TableConverter.typeArg(type, Map.class, 1);
    }

    static Type typeArg(Type type, Class<?> wantedRawType, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && wantedRawType.isAssignableFrom((Class)rawType)) {
                Type result = parameterizedType.getActualTypeArguments()[index];
                if (result instanceof TypeVariable) {
                    throw new ParserException("Generic types must be explicit");
                }
                return result;
            }
            return null;
        }
        return null;
    }

    static <T> List<T> toList(PickleTable dataTable, Type itemType, JsonElement testData) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<String> keys = TableConverter.convertTopCellsToFieldNames(TableConverter.raw(dataTable.getRows().get(0)));
        int count = dataTable.getRows().size();
        for (int i = 1; i < count; ++i) {
            List<String> valueRow = TableConverter.raw(dataTable.getRows().get(i));
            Object item = SuperReflect.on((Class)((Class)itemType)).create().get();
            int j = 0;
            for (String cell : valueRow) {
                SuperReflect.on((Object)item).set(keys.get(j), (Object)cell);
                ++j;
            }
            result.add(item);
        }
        return Collections.unmodifiableList(result);
    }

    static List<String> toStringList(PickleTable dataTable, JsonElement testData) {
        ArrayList<String> result = new ArrayList<String>();
        int count = dataTable.getRows().size();
        if (count == 1) {
            for (PickleCell cell : dataTable.getRows().get(0).getCells()) {
                result.add(TableConverter.replaceWithTestData(testData, cell.getValue()));
            }
        } else {
            for (PickleRow row : dataTable.getRows()) {
                result.add(TableConverter.replaceWithTestData(testData, row.getCells().get(0).getValue()));
            }
        }
        return Collections.unmodifiableList(result);
    }

    static List<Map<String, String>> toMaps(PickleTable dataTable) {
        ArrayList result = new ArrayList();
        List<String> keys = TableConverter.raw(dataTable.getRows().get(0));
        int count = dataTable.getRows().size();
        for (int i = 1; i < count; ++i) {
            List<String> valueRow = TableConverter.raw(dataTable.getRows().get(i));
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            int j = 0;
            for (String cell : valueRow) {
                map.put(keys.get(j), cell);
                ++j;
            }
            result.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(result);
    }

    private static List<List<String>> raw(PickleTable dataTable) {
        int columns = dataTable.getRows().isEmpty() ? 0 : dataTable.getRows().get(0).getCells().size();
        ArrayList<List<String>> raw = new ArrayList<List<String>>();
        for (PickleRow row : dataTable.getRows()) {
            if (columns != row.getCells().size()) {
                throw new ParserException(String.format("Table is unbalanced: expected %s column(s) but found %s.", columns, row.getCells().size()));
            }
            raw.add(Collections.unmodifiableList(TableConverter.raw(row)));
        }
        return Collections.unmodifiableList(raw);
    }

    private static List<String> raw(PickleRow row) {
        ArrayList<String> raw = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            raw.add(cell.getValue());
        }
        return Collections.unmodifiableList(raw);
    }

    static List<String> convertTopCellsToFieldNames(List<String> row) {
        CamelCaseStringConverter mapper = new CamelCaseStringConverter();
        ArrayList<String> result = new ArrayList<String>(row.size());
        for (String s : row) {
            result.add(mapper.map(s));
        }
        return result;
    }

    private static String replaceWithTestData(JsonElement sourceTestData, String inputString) {
        String[] pathElements;
        if (sourceTestData != null && inputString != null && inputString.startsWith("$(") && inputString.endsWith(")") && (pathElements = (inputString = inputString.substring("$(".length(), inputString.length() - ")".length())).split("\\.")) != null && pathElements.length > 0) {
            JsonElement elemPointer = sourceTestData;
            for (String element : pathElements) {
                if (!elemPointer.isJsonObject() || !elemPointer.getAsJsonObject().has(element)) {
                    elemPointer = null;
                    break;
                }
                elemPointer = elemPointer.getAsJsonObject().get(element);
            }
            if (elemPointer != null && elemPointer.isJsonPrimitive()) {
                JsonPrimitive primitive = elemPointer.getAsJsonPrimitive();
                if (primitive.isString() || primitive.isNumber()) {
                    return primitive.getAsString();
                }
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean() ? "true" : "false";
                }
            }
        }
        return inputString;
    }
}

