/*
 * Decompiled with CFR 0.152.
 */
package gherkin.pickles;

import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleTag;
import java.util.Collections;
import java.util.List;

public class Pickle {
    private final String name;
    private final List<PickleStep> steps;
    private final List<PickleTag> tags;
    private final List<PickleLocation> locations;

    public Pickle(String name, List<PickleStep> steps, List<PickleTag> tags, List<PickleLocation> locations) {
        this.name = name;
        this.steps = Collections.unmodifiableList(steps);
        this.tags = tags;
        this.locations = Collections.unmodifiableList(locations);
    }

    public String getName() {
        return this.name;
    }

    public List<PickleStep> getSteps() {
        return this.steps;
    }

    public List<PickleLocation> getLocations() {
        return this.locations;
    }

    public List<PickleTag> getTags() {
        return this.tags;
    }

    public String getIdentification() {
        StringBuilder builder = new StringBuilder();
        for (PickleLocation loc : this.locations) {
            builder.append(loc.getPath());
            builder.append(loc.getLine());
            builder.append(loc.getColumn());
        }
        builder.append(this.name);
        return builder.toString();
    }
}

