/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.model.ProductFlavorImpl;
import com.android.build.gradle.internal.model.SourceProviderContainerImpl;
import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

class ProductFlavorContainerImpl
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final ProductFlavor productFlavor;
    @NonNull
    private final SourceProvider sourceProvider;
    @NonNull
    private final Collection<SourceProviderContainer> extraSourceProviders;

    @NonNull
    static ProductFlavorContainer createPFC(@NonNull ProductFlavorData productFlavorData, @NonNull Collection<SourceProviderContainer> sourceProviderContainers) {
        List<SourceProviderContainer> clonedContainer = SourceProviderContainerImpl.cloneCollection(sourceProviderContainers);
        SourceProviderContainer testASP = SourceProviderContainerImpl.create("_android_test_", productFlavorData.getTestSourceSet());
        clonedContainer.add(testASP);
        return new ProductFlavorContainerImpl(ProductFlavorImpl.cloneFlavor(productFlavorData.getProductFlavor()), SourceProviderImpl.cloneProvider(productFlavorData.getSourceSet()), clonedContainer);
    }

    private ProductFlavorContainerImpl(@NonNull ProductFlavorImpl productFlavor, @NonNull SourceProviderImpl sourceProvider, @NonNull Collection<SourceProviderContainer> extraSourceProviders) {
        this.productFlavor = productFlavor;
        this.sourceProvider = sourceProvider;
        this.extraSourceProviders = extraSourceProviders;
    }

    @NonNull
    public ProductFlavor getProductFlavor() {
        return this.productFlavor;
    }

    @NonNull
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    @NonNull
    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.extraSourceProviders;
    }
}

