/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.tasks

import com.android.builder.core.AndroidBuilder
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.TaskAction

/**
 * Task to generate micro app data res file.
 */
public class GenerateApkDataTask extends BaseTask {

    @InputFile
    File apkFile

    @OutputDirectory
    File resOutputDir

    @OutputFile
    File manifestFile

    @Input
    String mainPkgName

    @TaskAction
    void generate() {
        // always empty output dir.
        File outDir = getResOutputDir()
        emptyFolder(outDir)

        AndroidBuilder builder = getBuilder();

        builder.generateApkData(getApkFile(), outDir, getMainPkgName())
        builder.generateApkDataEntryInManifest(getManifestFile())
    }
}
