/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;

public class MavenCoordinatesImpl
implements MavenCoordinates,
Serializable {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String classifier;

    public MavenCoordinatesImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    public MavenCoordinatesImpl(String groupId, String artifactId, String version, String packaging, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging != null ? packaging : "jar";
        this.classifier = classifier;
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String getPackaging() {
        return this.packaging;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        ArrayList segments = Lists.newArrayList((Object[])new String[]{this.groupId, this.artifactId, this.packaging});
        if (!Strings.isNullOrEmpty((String)this.classifier)) {
            segments.add(this.classifier);
        }
        segments.add(this.version);
        return Joiner.on((char)':').join((Iterable)segments);
    }
}

