/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.annotations.NonNull;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiDatabase {
    @NonNull
    private final List<String> lines;
    @NonNull
    private final Map<String, Set<String>> fieldMap = Maps.newHashMapWithExpectedSize((int)1000);
    @NonNull
    private final Map<String, Map<String, List<String>>> methodMap = Maps.newHashMapWithExpectedSize((int)1000);
    @NonNull
    private final Map<String, List<String>> inheritsFrom = Maps.newHashMapWithExpectedSize((int)1000);

    public ApiDatabase(@NonNull List<String> lines) {
        this.lines = lines;
        this.readApi();
    }

    public ApiDatabase(@NonNull File api) throws IOException {
        this(Files.readLines((File)api, (Charset)Charsets.UTF_8));
    }

    public boolean hasMethod(String className, String methodName, String arguments) {
        List<String> strings;
        Map<String, List<String>> methods = this.methodMap.get(className);
        if (methods != null && (strings = methods.get(methodName)) != null && strings.contains(arguments)) {
            return true;
        }
        List<String> inheritsFrom = this.inheritsFrom.get(className);
        if (inheritsFrom != null) {
            for (String clz : inheritsFrom) {
                if (!this.hasMethod(clz, methodName, arguments)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasField(String className, String fieldName) {
        Set<String> fields = this.fieldMap.get(className);
        if (fields != null && fields.contains(fieldName)) {
            return true;
        }
        List<String> inheritsFrom = this.inheritsFrom.get(className);
        if (inheritsFrom != null) {
            for (String clz : inheritsFrom) {
                if (!this.hasField(clz, fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    private void readApi() {
        String MODIFIERS = "((deprecated|public|static|private|protected|final|abstract|\\s*)\\s+)*";
        Pattern PACKAGE = Pattern.compile("package (\\S+) \\{");
        Pattern CLASS = Pattern.compile(MODIFIERS + "(class|interface|enum)\\s+(\\S+)\\s+(extends (.+))?(implements (.+))?(.*)\\{");
        Pattern METHOD = Pattern.compile("(method|ctor)\\s+" + MODIFIERS + "(.+)??\\s+(\\S+)\\s*\\((.*)\\)(.*);");
        Pattern CTOR = Pattern.compile("(method|ctor)\\s+.*\\((.*)\\)(.*);");
        Pattern FIELD = Pattern.compile("(enum_constant|field)\\s+" + MODIFIERS + "(.+)\\s+(\\S+)\\s*;");
        String currentPackage = null;
        String currentClass = null;
        for (String line : this.lines) {
            String implementsList;
            String signature;
            String methodName;
            List signatures;
            Map<Object, Object> memberMap;
            if ((line = line.trim()).isEmpty() || line.equals("}")) continue;
            if (line.startsWith("method ")) {
                Matcher matcher = METHOD.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                memberMap = this.methodMap.get(currentClass);
                if (memberMap == null) {
                    memberMap = Maps.newHashMap();
                    this.methodMap.put(currentClass, (Map<String, List<String>>)memberMap);
                }
                if ((signatures = (List)memberMap.get(methodName = matcher.group(5))) == null) {
                    signatures = Lists.newArrayList();
                    memberMap.put(methodName, signatures);
                }
                signature = matcher.group(6);
                signature = signature.trim().replace(" ", "").replace(" ", "");
                signatures.add(signature);
                continue;
            }
            if (line.startsWith("ctor ")) {
                Matcher matcher = CTOR.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                memberMap = this.methodMap.get(currentClass);
                if (memberMap == null) {
                    memberMap = Maps.newHashMap();
                    this.methodMap.put(currentClass, memberMap);
                }
                if ((signatures = (List)memberMap.get(methodName = currentClass)) == null) {
                    signatures = Lists.newArrayList();
                    memberMap.put(methodName, signatures);
                    memberMap.put(methodName.substring(methodName.lastIndexOf(46) + 1), signatures);
                }
                signature = matcher.group(2);
                signature = signature.trim().replace(" ", "").replace(" ", "");
                signatures.add(signature);
                continue;
            }
            if (line.startsWith("enum_constant ") || line.startsWith("field ")) {
                int semi;
                int equals = line.indexOf(61);
                if (equals != -1) {
                    int semi2 = (line = line.substring(0, equals).trim()).indexOf(59);
                    if (semi2 == -1) {
                        line = line + ';';
                    }
                } else if (!line.endsWith(";") && (semi = line.indexOf(59)) != -1) {
                    line = line.substring(0, semi + 1);
                }
                Matcher matcher = FIELD.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a member: " + line);
                    continue;
                }
                assert (currentClass != null);
                String fieldName = matcher.group(5);
                HashSet fieldSet = this.fieldMap.get(currentClass);
                if (fieldSet == null) {
                    fieldSet = Sets.newHashSet();
                    this.fieldMap.put(currentClass, fieldSet);
                }
                fieldSet.add(fieldName);
                continue;
            }
            if (line.startsWith("package ")) {
                Matcher matcher = PACKAGE.matcher(line);
                if (!matcher.matches()) {
                    Extractor.warning("Warning: Did not match as a package: " + line);
                    continue;
                }
                currentPackage = matcher.group(1);
                continue;
            }
            Matcher matcher = CLASS.matcher(line);
            if (!matcher.matches()) {
                Extractor.warning("Warning: Did not match as a class/interface: " + line);
                continue;
            }
            currentClass = currentPackage + '.' + matcher.group(4);
            String superClass = matcher.group(6);
            if (superClass != null) {
                Splitter splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings();
                for (String from : splitter.split((CharSequence)superClass)) {
                    if (from.equals("implements")) continue;
                    this.addInheritsFrom(currentClass, from);
                }
                this.addInheritsFrom(currentClass, superClass.trim());
            }
            if ((implementsList = matcher.group(8)) == null) continue;
            Splitter splitter = Splitter.on((char)' ').trimResults().omitEmptyStrings();
            for (String from : splitter.split((CharSequence)implementsList)) {
                this.addInheritsFrom(currentClass, from);
            }
        }
    }

    private void addInheritsFrom(String cls, String inheritsFrom) {
        ArrayList list = this.inheritsFrom.get(cls);
        if (list == null) {
            list = Lists.newArrayList();
            this.inheritsFrom.put(cls, list);
        }
        list.add(inheritsFrom);
    }
}

