/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.VariantFilterImpl;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildTypeDsl;
import com.android.build.gradle.internal.dsl.GroupableProductFlavorDsl;
import com.android.build.gradle.internal.dsl.SigningConfigDsl;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class VariantManager {
    @NonNull
    private final Project project;
    @NonNull
    private final BasePlugin basePlugin;
    @NonNull
    private final BaseExtension extension;
    @NonNull
    private final VariantFactory variantFactory;
    private final Map<String, BuildTypeData> buildTypes = Maps.newHashMap();
    private final Map<String, ProductFlavorData<GroupableProductFlavorDsl>> productFlavors = Maps.newHashMap();
    private final Map<String, SigningConfig> signingConfigs = Maps.newHashMap();
    private final VariantFilterImpl variantFilter = new VariantFilterImpl();

    public VariantManager(@NonNull Project project, @NonNull BasePlugin basePlugin, @NonNull BaseExtension extension, @NonNull VariantFactory variantFactory) {
        this.extension = extension;
        this.basePlugin = basePlugin;
        this.project = project;
        this.variantFactory = variantFactory;
    }

    @NonNull
    public Map<String, BuildTypeData> getBuildTypes() {
        return this.buildTypes;
    }

    @NonNull
    public Map<String, ProductFlavorData<GroupableProductFlavorDsl>> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    public void addSigningConfig(@NonNull SigningConfigDsl signingConfigDsl) {
        this.signingConfigs.put(signingConfigDsl.getName(), (SigningConfig)signingConfigDsl);
    }

    public void addBuildType(@NonNull BuildTypeDsl buildType) {
        buildType.init(this.signingConfigs.get("debug"));
        String name = buildType.getName();
        VariantManager.checkName(name, "BuildType");
        if (this.productFlavors.containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        DefaultAndroidSourceSet sourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(name);
        BuildTypeData buildTypeData = new BuildTypeData(buildType, sourceSet, this.project);
        this.project.getTasks().getByName("assemble").dependsOn(new Object[]{buildTypeData.getAssembleTask()});
        this.buildTypes.put(name, buildTypeData);
    }

    public void addProductFlavor(@NonNull GroupableProductFlavorDsl productFlavor) {
        String name = productFlavor.getName();
        VariantManager.checkName(name, "ProductFlavor");
        if (this.buildTypes.containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(productFlavor.getName());
        String testName = "androidTest" + StringHelper.capitalize(productFlavor.getName());
        DefaultAndroidSourceSet testSourceSet = (DefaultAndroidSourceSet)this.extension.getSourceSetsContainer().maybeCreate(testName);
        ProductFlavorData<GroupableProductFlavorDsl> productFlavorData = new ProductFlavorData<GroupableProductFlavorDsl>(productFlavor, mainSourceSet, testSourceSet, this.project);
        this.productFlavors.put(productFlavor.getName(), productFlavorData);
    }

    public void createAndroidTasks(@Nullable SigningConfig signingOverride) {
        this.basePlugin.createLintCompileTask();
        Splits splits = this.basePlugin.getExtension().getSplits();
        Set<String> densities = splits.getDensityFilters();
        Set<String> abis = splits.getAbiFilters();
        if (this.productFlavors.isEmpty()) {
            this.createTasksForDefaultBuild(densities, abis, signingOverride);
        } else {
            Task assembleTest = this.project.getTasks().create("assembleTest");
            assembleTest.setGroup("build");
            assembleTest.setDescription("Assembles all the Test applications");
            this.basePlugin.setAssembleTest(assembleTest);
            List<String> flavorDimensionList = this.extension.getFlavorDimensionList();
            if (flavorDimensionList == null || flavorDimensionList.size() < 2) {
                for (ProductFlavorData<GroupableProductFlavorDsl> productFlavorData : this.productFlavors.values()) {
                    this.createTasksForFlavoredBuild(densities, abis, signingOverride, productFlavorData);
                }
            } else {
                ArrayListMultimap map = ArrayListMultimap.create();
                for (ProductFlavorData<GroupableProductFlavorDsl> productFlavorData : this.productFlavors.values()) {
                    GroupableProductFlavorDsl flavor = productFlavorData.getProductFlavor();
                    String flavorDimension = flavor.getFlavorDimension();
                    if (flavorDimension == null) {
                        throw new RuntimeException(String.format("Flavor '%1$s' has no flavor dimension.", flavor.getName()));
                    }
                    if (!flavorDimensionList.contains(flavorDimension)) {
                        throw new RuntimeException(String.format("Flavor '%1$s' has unknown dimension '%2$s'.", flavor.getName(), flavor.getFlavorDimension()));
                    }
                    map.put((Object)flavorDimension, productFlavorData);
                }
                ProductFlavorData[] array = new ProductFlavorData[flavorDimensionList.size()];
                this.createTasksForMultiFlavoredBuilds(array, 0, (ListMultimap<String, ? extends ProductFlavorData>)map, densities, abis, signingOverride);
            }
        }
        this.basePlugin.createLintTasks();
        this.basePlugin.createCheckTasks(!this.productFlavors.isEmpty(), false);
        this.createApiObjects();
    }

    private void createTasksForMultiFlavoredBuilds(@NonNull ProductFlavorData[] datas, int index, @NonNull ListMultimap<String, ? extends ProductFlavorData> map, @NonNull Set<String> densities, @NonNull Set<String> abis, @Nullable SigningConfig signingOverride) {
        if (index == datas.length) {
            this.createTasksForFlavoredBuild(densities, abis, signingOverride, datas);
            return;
        }
        String dimension = this.extension.getFlavorDimensionList().get(index);
        List flavorList = map.get((Object)dimension);
        Iterator i$ = flavorList.iterator();
        while (i$.hasNext()) {
            ProductFlavorData flavor;
            datas[index] = flavor = (ProductFlavorData)i$.next();
            this.createTasksForMultiFlavoredBuilds(datas, index + 1, map, densities, abis, signingOverride);
        }
    }

    private void createTasksForDefaultBuild(@NonNull Set<String> densities, @NonNull Set<String> abis, @Nullable SigningConfig signingOverride) {
        BuildTypeData testData = this.buildTypes.get(this.extension.getTestBuildType());
        if (testData == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", this.extension.getTestBuildType()));
        }
        BaseVariantData testedVariantData = null;
        ProductFlavorData defaultConfigData = this.basePlugin.getDefaultConfigData();
        Object defaultConfig = defaultConfigData.getProductFlavor();
        DefaultAndroidSourceSet defaultConfigSourceSet = defaultConfigData.getSourceSet();
        Closure<Void> variantFilterClosure = this.basePlugin.getExtension().getVariantFilter();
        Set<String> compatibleScreens = this.basePlugin.getExtension().getSplits().getDensity().getCompatibleScreens();
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (variantFilterClosure != null) {
                this.variantFilter.reset((ProductFlavor)defaultConfig, (BuildType)buildTypeData.getBuildType(), null);
                variantFilterClosure.call((Object)this.variantFilter);
                ignore = this.variantFilter.isIgnore();
            }
            if (ignore) continue;
            VariantConfiguration variantConfig = new VariantConfiguration(defaultConfig, (SourceProvider)defaultConfigSourceSet, buildTypeData.getBuildType(), (SourceProvider)buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), signingOverride);
            Object variantData = this.variantFactory.createVariantData(variantConfig, densities, abis, compatibleScreens);
            VariantDependencies variantDep = VariantDependencies.compute(this.project, variantConfig.getFullName(), this.isVariantPublished(), this.variantFactory.isLibrary(), buildTypeData, defaultConfigData.getMainProvider());
            ((BaseVariantData)variantData).setVariantDependency(variantDep);
            if (buildTypeData == testData) {
                testedVariantData = variantData;
            }
            this.basePlugin.resolveDependencies(variantDep);
            variantConfig.setDependencies((DependencyContainer)variantDep);
            this.basePlugin.getVariantDataList().add((BaseVariantData<? extends BaseVariantOutputData>)variantData);
            this.variantFactory.createTasks((BaseVariantData<?>)variantData, this.buildTypes.get(variantConfig.getBuildType().getName()).getAssembleTask());
        }
        if (testedVariantData != null) {
            VariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
            VariantConfiguration testVariantConfig = new VariantConfiguration(defaultConfig, (SourceProvider)defaultConfigData.getTestSourceSet(), testData.getBuildType(), null, VariantConfiguration.Type.TEST, testedConfig, signingOverride);
            TestVariantData testVariantData = new TestVariantData(this.basePlugin, testVariantConfig, (TestedVariantData)((Object)testedVariantData));
            ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData);
            VariantDependencies variantDep = VariantDependencies.compute(this.project, testVariantConfig.getFullName(), false, this.variantFactory.isLibrary(), defaultConfigData.getTestProvider(), testedConfig.getType() == VariantConfiguration.Type.LIBRARY ? testedVariantData.getVariantDependency() : null);
            testVariantData.setVariantDependency(variantDep);
            this.basePlugin.resolveDependencies(variantDep);
            testVariantConfig.setDependencies((DependencyContainer)variantDep);
            this.basePlugin.getVariantDataList().add(testVariantData);
            this.basePlugin.createTestApkTasks(testVariantData, testedVariantData);
        }
    }

    private void createTasksForFlavoredBuild(@NonNull Set<String> densities, @NonNull Set<String> abis, @Nullable SigningConfig signingOverride, ProductFlavorData ... flavorDataList) {
        BuildTypeData testData = this.buildTypes.get(this.extension.getTestBuildType());
        if (testData == null) {
            throw new RuntimeException(String.format("Test Build Type '%1$s' does not exist.", this.extension.getTestBuildType()));
        }
        ArrayList localVariantDataList = Lists.newArrayListWithCapacity((int)this.buildTypes.size());
        BaseVariantData testedVariantData = null;
        Task assembleTask = null;
        ProductFlavorData defaultConfigData = this.basePlugin.getDefaultConfigData();
        Object defaultConfig = defaultConfigData.getProductFlavor();
        DefaultAndroidSourceSet defaultConfigSourceSet = defaultConfigData.getSourceSet();
        ArrayList variantProviders = Lists.newArrayListWithCapacity((int)(flavorDataList.length + 2));
        Closure<Void> variantFilterClosure = this.basePlugin.getExtension().getVariantFilter();
        ArrayList productFlavorList = variantFilterClosure != null ? Lists.newArrayListWithCapacity((int)flavorDataList.length) : null;
        Set<String> compatibleScreens = this.basePlugin.getExtension().getSplits().getDensity().getCompatibleScreens();
        for (BuildTypeData buildTypeData : this.buildTypes.values()) {
            boolean ignore = false;
            if (variantFilterClosure != null) {
                productFlavorList.clear();
                for (ProductFlavorData data : flavorDataList) {
                    productFlavorList.add(data.getProductFlavor());
                }
                this.variantFilter.reset((ProductFlavor)defaultConfig, (BuildType)buildTypeData.getBuildType(), productFlavorList);
                variantFilterClosure.call((Object)this.variantFilter);
                ignore = this.variantFilter.isIgnore();
            }
            if (ignore) continue;
            if (assembleTask == null && flavorDataList.length > 1) {
                assembleTask = this.createAssembleTask(flavorDataList);
                this.project.getTasks().getByName("assemble").dependsOn(new Object[]{assembleTask});
            }
            variantProviders.clear();
            variantProviders.add(buildTypeData);
            VariantConfiguration variantConfig = new VariantConfiguration(defaultConfig, (SourceProvider)defaultConfigSourceSet, buildTypeData.getBuildType(), (SourceProvider)buildTypeData.getSourceSet(), this.variantFactory.getVariantConfigurationType(), signingOverride);
            for (ProductFlavorData data : flavorDataList) {
                String dimensionName = "";
                Object productFlavor = data.getProductFlavor();
                if (productFlavor instanceof GroupableProductFlavorDsl) {
                    dimensionName = ((GroupableProductFlavorDsl)((Object)productFlavor)).getFlavorDimension();
                }
                variantConfig.addProductFlavor(productFlavor, (SourceProvider)data.getSourceSet(), dimensionName);
                variantProviders.add(data.getMainProvider());
            }
            variantProviders.add(this.basePlugin.getDefaultConfigData().getMainProvider());
            Object variantData = this.variantFactory.createVariantData(variantConfig, densities, abis, compatibleScreens);
            NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer = this.extension.getSourceSetsContainer();
            DefaultAndroidSourceSet variantSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFullName());
            variantConfig.setVariantSourceProvider((SourceProvider)variantSourceSet);
            if (flavorDataList.length > 1) {
                DefaultAndroidSourceSet multiFlavorSourceSet = (DefaultAndroidSourceSet)sourceSetsContainer.maybeCreate(variantConfig.getFlavorName());
                variantConfig.setMultiFlavorSourceProvider((SourceProvider)multiFlavorSourceSet);
            }
            VariantDependencies variantDep = VariantDependencies.compute(this.project, variantConfig.getFullName(), this.isVariantPublished(), this.variantFactory.isLibrary(), variantProviders.toArray(new ConfigurationProvider[variantProviders.size()]));
            ((BaseVariantData)variantData).setVariantDependency(variantDep);
            localVariantDataList.add(variantData);
            if (buildTypeData == testData) {
                testedVariantData = variantData;
            }
            this.basePlugin.resolveDependencies(variantDep);
            variantConfig.setDependencies((DependencyContainer)variantDep);
            this.basePlugin.getVariantDataList().add((BaseVariantData<? extends BaseVariantOutputData>)variantData);
            this.variantFactory.createTasks((BaseVariantData<?>)variantData, null);
            buildTypeData.getAssembleTask().dependsOn(new Object[]{((BaseVariantData)variantData).assembleVariantTask});
            for (ProductFlavorData data : flavorDataList) {
                data.getAssembleTask().dependsOn(new Object[]{((BaseVariantData)variantData).assembleVariantTask});
            }
            if (assembleTask == null) continue;
            assembleTask.dependsOn(new Object[]{((BaseVariantData)variantData).assembleVariantTask});
        }
        if (testedVariantData != null) {
            VariantConfiguration testedConfig = testedVariantData.getVariantConfiguration();
            VariantConfiguration testVariantConfig = new VariantConfiguration(defaultConfig, (SourceProvider)defaultConfigData.getTestSourceSet(), testData.getBuildType(), null, VariantConfiguration.Type.TEST, testedVariantData.getVariantConfiguration(), signingOverride);
            ArrayList testVariantProviders = Lists.newArrayListWithExpectedSize((int)(1 + flavorDataList.length));
            for (ProductFlavorData data : flavorDataList) {
                String dimensionName = "";
                Object productFlavor = data.getProductFlavor();
                if (productFlavor instanceof GroupableProductFlavorDsl) {
                    dimensionName = ((GroupableProductFlavorDsl)((Object)productFlavor)).getFlavorDimension();
                }
                testVariantConfig.addProductFlavor(productFlavor, (SourceProvider)data.getTestSourceSet(), dimensionName);
                testVariantProviders.add(data.getTestProvider());
            }
            testVariantProviders.add(this.basePlugin.getDefaultConfigData().getTestProvider());
            TestVariantData testVariantData = new TestVariantData(this.basePlugin, testVariantConfig, (TestedVariantData)((Object)testedVariantData));
            localVariantDataList.add(testVariantData);
            ((TestedVariantData)((Object)testedVariantData)).setTestVariantData(testVariantData);
            if (testedConfig.getType() == VariantConfiguration.Type.LIBRARY) {
                testVariantProviders.add(testedVariantData.getVariantDependency());
            }
            VariantDependencies variantDep = VariantDependencies.compute(this.project, testVariantData.getVariantConfiguration().getFullName(), false, this.variantFactory.isLibrary(), testVariantProviders.toArray(new ConfigurationProvider[testVariantProviders.size()]));
            testVariantData.setVariantDependency(variantDep);
            this.basePlugin.resolveDependencies(variantDep);
            testVariantConfig.setDependencies((DependencyContainer)variantDep);
            this.basePlugin.getVariantDataList().add(testVariantData);
            this.basePlugin.createTestApkTasks(testVariantData, (BaseVariantData)((Object)testVariantData.getTestedVariantData()));
        }
    }

    @NonNull
    private Task createAssembleTask(ProductFlavorData[] flavorDataList) {
        String name = ProductFlavorData.getFlavoredName(flavorDataList, true);
        Task assembleTask = this.project.getTasks().create("assemble" + name);
        assembleTask.setDescription("Assembles all builds for flavor combination: " + name);
        assembleTask.setGroup("Build");
        return assembleTask;
    }

    private void createApiObjects() {
        HashMap map = Maps.newHashMap();
        for (BaseVariantData<? extends BaseVariantOutputData> variantData : this.basePlugin.getVariantDataList()) {
            if (map.get(variantData) != null) continue;
            if (variantData instanceof TestVariantData) {
                TestVariantData testVariantData = (TestVariantData)variantData;
                this.createVariantApiObjects(map, (BaseVariantData)((Object)testVariantData.getTestedVariantData()), testVariantData);
                continue;
            }
            this.createVariantApiObjects(map, variantData, ((TestedVariantData)((Object)variantData)).getTestVariantData());
        }
    }

    private boolean isVariantPublished() {
        return this.extension.getPublishNonDefault();
    }

    private void createVariantApiObjects(@NonNull Map<BaseVariantData, BaseVariant> map, @NonNull BaseVariantData<?> variantData, @Nullable TestVariantData testVariantData) {
        BaseVariant variantApi = this.variantFactory.createVariantApi(variantData);
        TestVariantImpl testVariant = null;
        if (testVariantData != null) {
            testVariant = (TestVariantImpl)this.basePlugin.getInstantiator().newInstance(TestVariantImpl.class, new Object[]{testVariantData, this.basePlugin});
            ApplicationVariantFactory.createApkOutputApiObjects(this.basePlugin, testVariantData, testVariant);
        }
        if (testVariant != null) {
            ((TestedVariant)((Object)variantApi)).setTestVariant(testVariant);
            testVariant.setTestedVariant(variantApi);
        }
        this.extension.addVariant(variantApi);
        map.put(variantData, variantApi);
        if (testVariant != null) {
            this.extension.addTestVariant(testVariant);
            map.put(testVariantData, testVariant);
        }
    }

    private static void checkName(@NonNull String name, @NonNull String displayName) {
        if (name.startsWith("androidTest")) {
            throw new RuntimeException(String.format("%1$s names cannot start with '%2$s'", displayName, "androidTest"));
        }
        if (name.startsWith("uiTest")) {
            throw new RuntimeException(String.format("%1$s names cannot start with %2$s", displayName, "uiTest"));
        }
        if ("lint".equals(name)) {
            throw new RuntimeException(String.format("%1$s names cannot be %2$s", displayName, "lint"));
        }
    }
}

