/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantData<T extends BaseVariantOutputData> {
    @NonNull
    protected final BasePlugin basePlugin;
    @NonNull
    private final VariantConfiguration variantConfiguration;
    private VariantDependencies variantDependency;
    public Task preBuildTask;
    public PrepareDependenciesTask prepareDependenciesTask;
    public ProcessAndroidResources generateRClassTask;
    public Task sourceGenTask;
    public Task resourceGenTask;
    public Task assetGenTask;
    public CheckManifest checkManifestTask;
    public RenderscriptCompile renderscriptCompileTask;
    public AidlCompile aidlCompileTask;
    public MergeResources mergeResourcesTask;
    public MergeAssets mergeAssetsTask;
    public GenerateBuildConfig generateBuildConfigTask;
    public GenerateResValues generateResValuesTask;
    public Copy copyApkTask;
    public GenerateApkDataTask generateApkDataTask;
    public JavaCompile javaCompileTask;
    public Copy processJavaResourcesTask;
    public NdkCompile ndkCompileTask;
    public Task compileTask;
    public Task obfuscationTask;
    public File mappingFile;
    public Task assembleVariantTask;
    private Object[] javaSources;
    private List<File> extraGeneratedSourceFolders;
    private final List<T> outputs = Lists.newArrayListWithExpectedSize((int)4);

    public BaseVariantData(@NonNull BasePlugin basePlugin, @NonNull VariantConfiguration variantConfiguration) {
        this.basePlugin = basePlugin;
        this.variantConfiguration = variantConfiguration;
        variantConfiguration.checkSourceProviders();
    }

    @NonNull
    protected abstract T doCreateOutput(@Nullable String var1, @Nullable String var2);

    @NonNull
    public T createOutput(@Nullable String densityFilter, @Nullable String abiFilter) {
        T data = this.doCreateOutput(densityFilter, abiFilter);
        if (this.outputs.size() == 1) {
            ((BaseVariantOutputData)this.outputs.get(0)).setMultiOutput(true);
            ((BaseVariantOutputData)data).setMultiOutput(true);
        } else if (this.outputs.size() > 1) {
            ((BaseVariantOutputData)data).setMultiOutput(true);
        }
        this.outputs.add(data);
        return data;
    }

    @NonNull
    public List<T> getOutputs() {
        return this.outputs;
    }

    @NonNull
    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantDependency(@NonNull VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    @NonNull
    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    @NonNull
    public abstract String getDescription();

    @NonNull
    public String getApplicationId() {
        return this.variantConfiguration.getApplicationId();
    }

    @NonNull
    protected String getCapitalizedBuildTypeName() {
        return StringHelper.capitalize(this.variantConfiguration.getBuildType().getName());
    }

    @NonNull
    protected String getCapitalizedFlavorName() {
        return StringHelper.capitalize(this.variantConfiguration.getFlavorName());
    }

    @NonNull
    String getName() {
        return this.variantConfiguration.getFullName();
    }

    @Nullable
    public List<File> getExtraGeneratedSourceFolders() {
        return this.extraGeneratedSourceFolders;
    }

    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        Collections.addAll(this.extraGeneratedSourceFolders, generatedSourceFolders);
    }

    public void addJavaSourceFoldersToModel(@NonNull Collection<File> generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        this.extraGeneratedSourceFolders.addAll(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(@NonNull Task task, File ... generatedSourceFolders) {
        this.sourceGenTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            this.javaCompileTask.source(new Object[]{f});
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(@NonNull Task task, @NonNull Collection<File> generatedSourceFolders) {
        this.sourceGenTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            this.javaCompileTask.source(new Object[]{f});
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @NonNull
    public Object[] getJavaSources() {
        if (this.javaSources == null) {
            ArrayList sourceList = Lists.newArrayList();
            List providers = this.variantConfiguration.getSortedSourceProviders();
            for (SourceProvider provider : providers) {
                sourceList.add(((AndroidSourceSet)provider).getJava().getSourceFiles());
            }
            sourceList.add(this.generateRClassTask.getSourceOutputDir());
            sourceList.add(this.generateBuildConfigTask.getSourceOutputDir());
            sourceList.add(this.aidlCompileTask.getSourceOutputDir());
            if (!this.variantConfiguration.getMergedFlavor().getRenderscriptNdkMode()) {
                sourceList.add(this.renderscriptCompileTask.getSourceOutputDir());
            }
            this.javaSources = sourceList.toArray();
        }
        return this.javaSources;
    }

    @NonNull
    public List<File> getJavaSourceFoldersForCoverage() {
        ArrayList sourceFolders = Lists.newArrayList();
        List providers = this.variantConfiguration.getSortedSourceProviders();
        for (SourceProvider provider : providers) {
            for (File sourceFolder : provider.getJavaDirectories()) {
                if (!sourceFolder.isDirectory()) continue;
                sourceFolders.add(sourceFolder);
            }
        }
        File sourceFolder = this.aidlCompileTask.getSourceOutputDir();
        if (sourceFolder.isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        if (!this.variantConfiguration.getMergedFlavor().getRenderscriptNdkMode() && (sourceFolder = this.renderscriptCompileTask.getSourceOutputDir()).isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        return sourceFolders;
    }
}

