/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.ndk.NdkExtension;
import com.android.build.gradle.ndk.NdkPlugin;
import com.android.build.gradle.ndk.internal.StlConfiguration;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectInternal;

public class NdkExtensionConventionAction
implements Action<ProjectInternal> {
    private static final String DEFAULT_TOOLCHAIN = "gcc";
    private static final String DEFAULT_GCC_VERSION = "4.6";
    private static final String DEFAULT_GCC_L_VERSION = "4.9";
    private static final String DEFAULT_CLANG_VERSION = "3.4";
    private static final String DEFAULT_STL = "system";

    public void execute(ProjectInternal project) {
        NdkExtension extension = ((NdkPlugin)project.getPlugins().getPlugin(NdkPlugin.class)).getNdkExtension();
        if (extension.getModuleName() == null || extension.getModuleName().isEmpty()) {
            throw new InvalidUserDataException("moduleName must be set for Android NDK plugin.");
        }
        if (extension.getCompileSdkVersion() == null) {
            BasePlugin androidPlugin = (BasePlugin)project.getPlugins().findPlugin(AppPlugin.class);
            if (androidPlugin == null) {
                androidPlugin = (BasePlugin)project.getPlugins().findPlugin(LibraryPlugin.class);
            }
            if (androidPlugin != null) {
                extension.setCompileSdkVersion(androidPlugin.getExtension().getCompileSdkVersion());
            } else {
                throw new InvalidUserDataException("compileSdkVersion must be set for Android NDK plugin.");
            }
        }
        if (extension.getToolchain() == null) {
            extension.setToolchain(DEFAULT_TOOLCHAIN);
        }
        if (extension.getToolchainVersion() == null) {
            extension.setToolchainVersion(extension.getToolchain().equals(DEFAULT_TOOLCHAIN) ? (extension.getCompileSdkVersion().equals("android-L") ? DEFAULT_GCC_L_VERSION : DEFAULT_GCC_VERSION) : DEFAULT_CLANG_VERSION);
        }
        if (extension.getCFilePattern().getIncludes().isEmpty()) {
            extension.getCFilePattern().include(new String[]{"**/*.c"});
        }
        if (extension.getCppFilePattern().getIncludes().isEmpty()) {
            extension.getCppFilePattern().include(new String[]{"**/*.cpp"});
            extension.getCppFilePattern().include(new String[]{"**/*.cc"});
        }
        if (extension.getStl() == null) {
            extension.setStl(DEFAULT_STL);
        } else {
            StlConfiguration.checkStl(extension.getStl());
        }
        extension.getSourceSets().maybeCreate("main");
        for (AndroidSourceDirectorySet sourceSet : extension.getSourceSets()) {
            if (!sourceSet.getSrcDirs().isEmpty()) continue;
            sourceSet.srcDir("src/" + sourceSet.getName() + "/jni");
        }
    }
}

