/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.DefaultBuildType;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;

abstract class BaseVariantImpl
implements BaseVariant {
    @NonNull
    protected BasePlugin plugin;
    protected List<BaseVariantOutput> outputs = Lists.newArrayListWithExpectedSize((int)1);

    BaseVariantImpl(@NonNull BasePlugin plugin) {
        this.plugin = plugin;
    }

    @NonNull
    protected abstract BaseVariantData<?> getVariantData();

    public void addOutputs(@NonNull List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    @NonNull
    public String getName() {
        return this.getVariantData().getVariantConfiguration().getFullName();
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    @NonNull
    public String getDirName() {
        return this.getVariantData().getVariantConfiguration().getDirName();
    }

    @Override
    @NonNull
    public String getBaseName() {
        return this.getVariantData().getVariantConfiguration().getBaseName();
    }

    @Override
    @NonNull
    public String getFlavorName() {
        return this.getVariantData().getVariantConfiguration().getFlavorName();
    }

    @Override
    @NonNull
    public List<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    @NonNull
    public DefaultBuildType getBuildType() {
        return this.getVariantData().getVariantConfiguration().getBuildType();
    }

    @Override
    @NonNull
    public List<DefaultProductFlavor> getProductFlavors() {
        return this.getVariantData().getVariantConfiguration().getFlavorConfigs();
    }

    @Override
    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.getVariantData().getVariantConfiguration().getMergedFlavor();
    }

    @Override
    @NonNull
    public List<SourceProvider> getSourceSets() {
        return this.getVariantData().getVariantConfiguration().getSortedSourceProviders();
    }

    @Override
    @NonNull
    public String getApplicationId() {
        return this.getVariantData().getApplicationId();
    }

    @Override
    @NonNull
    public Task getPreBuild() {
        return this.getVariantData().preBuildTask;
    }

    @Override
    @NonNull
    public Task getCheckManifest() {
        return this.getVariantData().checkManifestTask;
    }

    @Override
    @NonNull
    public AidlCompile getAidlCompile() {
        return this.getVariantData().aidlCompileTask;
    }

    @Override
    @NonNull
    public RenderscriptCompile getRenderscriptCompile() {
        return this.getVariantData().renderscriptCompileTask;
    }

    @Override
    public MergeResources getMergeResources() {
        return this.getVariantData().mergeResourcesTask;
    }

    @Override
    public MergeAssets getMergeAssets() {
        return this.getVariantData().mergeAssetsTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.getVariantData().generateBuildConfigTask;
    }

    @Override
    @NonNull
    public JavaCompile getJavaCompile() {
        return this.getVariantData().javaCompileTask;
    }

    @Override
    @NonNull
    public NdkCompile getNdkCompile() {
        return this.getVariantData().ndkCompileTask;
    }

    @Override
    @Nullable
    public Task getObfuscation() {
        return this.getVariantData().obfuscationTask;
    }

    @Override
    @Nullable
    public File getMappingFile() {
        return this.getVariantData().mappingFile;
    }

    @Override
    @NonNull
    public Copy getProcessJavaResources() {
        return this.getVariantData().processJavaResourcesTask;
    }

    @Override
    @Nullable
    public Task getAssemble() {
        return this.getVariantData().assembleVariantTask;
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(@NonNull Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(@NonNull Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(@NonNull Task task, @NonNull Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    @NonNull
    public String getPackageName() {
        this.plugin.displayDeprecationWarning("variant.getPackageName() is deprecated. Use getApplicationId() instead");
        return this.getApplicationId();
    }

    @Override
    @Deprecated
    public void setOutputFile(@NonNull File outputFile) {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call setOutput() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.setOutputFile() is deprecated. Call it on one of variant.getOutputs() instead.");
        this.outputs.get(0).setOutputFile(outputFile);
    }

    @Override
    @Deprecated
    @NonNull
    public File getOutputFile() {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call getOutputFile() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.getOutputFile() is deprecated. Call it on one of variant.getOutputs() instead.");
        return this.outputs.get(0).getOutputFile();
    }

    @Override
    @Deprecated
    @NonNull
    public ManifestProcessorTask getProcessManifest() {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call getProcessManifest() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.getProcessManifest() is deprecated. Call it on one of variant.getOutputs() instead.");
        return this.outputs.get(0).getProcessManifest();
    }

    @Override
    @Deprecated
    @NonNull
    public ProcessAndroidResources getProcessResources() {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call getProcessResources() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.getProcessResources() is deprecated. Call it on one of variant.getOutputs() instead.");
        return this.outputs.get(0).getProcessResources();
    }
}

