/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ZipAlign;
import java.io.File;

public class ApkVariantOutputData
extends BaseVariantOutputData {
    public PackageApplication packageApplicationTask;
    public ZipAlign zipAlignTask;
    private int versionCodeOverride = -1;

    public ApkVariantOutputData(@Nullable String densityFilter, @Nullable String abiFilter, @NonNull BaseVariantData variantData) {
        super(densityFilter, abiFilter, variantData);
    }

    @Override
    public void setOutputFile(@NonNull File file) {
        if (this.zipAlignTask != null) {
            this.zipAlignTask.setOutputFile(file);
        } else {
            this.packageApplicationTask.setOutputFile(file);
        }
    }

    @NonNull
    public File getOutputFile() {
        if (this.zipAlignTask != null) {
            return this.zipAlignTask.getOutputFile();
        }
        return this.packageApplicationTask.getOutputFile();
    }

    @NonNull
    public ZipAlign createZipAlignTask(@NonNull String taskName, @NonNull File inputFile, @NonNull File outputFile) {
        if (this.zipAlignTask != null) {
            throw new RuntimeException(String.format("ZipAlign task for variant '%s' already exists.", this.variantData.getName()));
        }
        this.zipAlignTask = this.variantData.basePlugin.createZipAlignTask(taskName, inputFile, outputFile);
        this.assembleTask.dependsOn(new Object[]{this.zipAlignTask});
        return this.zipAlignTask;
    }

    public int getVersionCode() {
        if (this.versionCodeOverride > 0) {
            return this.versionCodeOverride;
        }
        return this.variantData.getVariantConfiguration().getMergedFlavor().getVersionCode();
    }

    public void setVersionCodeOverride(int versionCodeOverride) {
        this.versionCodeOverride = versionCodeOverride;
    }

    public int getVersionCodeOverride() {
        return this.versionCodeOverride;
    }
}

