/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.SplitOutput;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import java.io.File;
import org.gradle.api.Task;

public abstract class BaseVariantOutputData
implements SplitOutput {
    private static final String UNIVERSAL = "universal";
    @NonNull
    protected final BaseVariantData<?> variantData;
    @Nullable
    private final String densityFilter;
    @Nullable
    private final String abiFilter;
    private boolean multiOutput = false;
    public ManifestProcessorTask manifestProcessorTask;
    public ProcessAndroidResources processResourcesTask;
    public Task assembleTask;

    public BaseVariantOutputData(@Nullable String densityFilter, @Nullable String abiFilter, @NonNull BaseVariantData<?> variantData) {
        this.densityFilter = densityFilter;
        this.abiFilter = abiFilter;
        this.variantData = variantData;
    }

    @Nullable
    public String getDensityFilter() {
        return this.densityFilter;
    }

    @Nullable
    public String getAbiFilter() {
        return this.abiFilter;
    }

    public abstract void setOutputFile(@NonNull File var1);

    @NonNull
    public String getFullName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getFullName();
        }
        return this.variantData.getVariantConfiguration().computeFullNameWithSplits(this.getFilterName());
    }

    @NonNull
    public String getBaseName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getBaseName();
        }
        return this.variantData.getVariantConfiguration().computeBaseNameWithSplits(this.getFilterName());
    }

    @NonNull
    public String getDirName() {
        if (!this.multiOutput) {
            return this.variantData.getVariantConfiguration().getDirName();
        }
        return this.variantData.getVariantConfiguration().computeDirNameWithSplits(new String[]{this.densityFilter, this.abiFilter});
    }

    @NonNull
    private String getFilterName() {
        if (this.densityFilter == null && this.abiFilter == null) {
            return UNIVERSAL;
        }
        StringBuilder sb = new StringBuilder();
        if (this.densityFilter != null) {
            sb.append(this.densityFilter);
        }
        if (this.abiFilter != null) {
            if (sb.length() > 0) {
                sb.append(StringHelper.capitalize(this.abiFilter));
            } else {
                sb.append(this.abiFilter);
            }
        }
        return sb.toString();
    }

    void setMultiOutput(boolean multiOutput) {
        this.multiOutput = multiOutput;
    }
}

