/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dsl.GroupableProductFlavorDsl;
import com.android.builder.model.SigningConfig;

import java.util.Map;

/**
 * Provides information about the build types, product flavors and signing configurations.
 */
public interface VariantModel {
    @NonNull
    public Map<String, BuildTypeData> getBuildTypes();

    @NonNull
    public Map<String, ProductFlavorData<GroupableProductFlavorDsl>> getProductFlavors();

    @NonNull
    public Map<String, SigningConfig> getSigningConfigs();
}
