/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.MainOutputFile;
import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifactOutput;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;

public class AndroidArtifactOutputImpl
implements AndroidArtifactOutput,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final File generatedManifest;
    @NonNull
    private final String assembleTaskName;
    private final int versionCode;
    private final Collection<OutputFile> outputFiles;
    private final MainOutputFile mainOutputFile;

    AndroidArtifactOutputImpl(@NonNull Collection<OutputFile> outputFiles, @NonNull String assembleTaskName, @NonNull File generatedManifest, int versionCode) {
        this.generatedManifest = generatedManifest;
        this.assembleTaskName = assembleTaskName;
        this.versionCode = versionCode;
        this.outputFiles = outputFiles;
        for (OutputFile outputFile : outputFiles) {
            if (!outputFile.getOutputType().equals(OutputFile.MAIN) && !outputFile.getOutputType().equals(OutputFile.FULL_SPLIT)) continue;
            this.mainOutputFile = (MainOutputFile)outputFile;
            return;
        }
        throw new IllegalStateException("No main output file for variant");
    }

    @NonNull
    public MainOutputFile getMainOutputFile() {
        return this.mainOutputFile;
    }

    @NonNull
    public Collection<OutputFile> getOutputs() {
        return this.outputFiles;
    }

    @NonNull
    public String getAssembleTaskName() {
        return this.assembleTaskName;
    }

    @NonNull
    public File getGeneratedManifest() {
        return this.generatedManifest;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    @NonNull
    public File getSplitFolder() {
        return this.getMainOutputFile().getOutputFile().getParentFile();
    }
}

