/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.ApiVersion;
import com.android.sdklib.AndroidVersion;
import java.io.Serializable;

public class ApiVersionImpl
implements ApiVersion,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int mApiLevel;
    @Nullable
    private final String mCodename;

    @Nullable
    public static ApiVersion clone(@Nullable ApiVersion apiVersion) {
        if (apiVersion == null) {
            return null;
        }
        return new ApiVersionImpl(apiVersion);
    }

    public static ApiVersion clone(@NonNull AndroidVersion androidVersion) {
        return new ApiVersionImpl(androidVersion.getApiLevel(), androidVersion.getCodename());
    }

    private ApiVersionImpl(@NonNull ApiVersion apiVersion) {
        this(apiVersion.getApiLevel(), apiVersion.getCodename());
    }

    private ApiVersionImpl(int apiLevel, @Nullable String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = codename;
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    @Nullable
    public String getCodename() {
        return this.mCodename;
    }

    @NonNull
    public String getApiString() {
        return this.mCodename != null ? this.mCodename : Integer.toString(this.mApiLevel);
    }
}

