/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.core.NdkConfig;
import com.android.build.gradle.internal.dsl.BuildTypeDsl;
import com.android.build.gradle.internal.dsl.GroupableProductFlavorDsl;
import com.android.build.gradle.internal.dsl.ProductFlavorDsl;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import java.util.List;
import java.util.Set;

public class GradleVariantConfiguration
extends VariantConfiguration<BuildTypeDsl, ProductFlavorDsl, GroupableProductFlavorDsl> {
    private final MergedNdkConfig mMergedNdkConfig = new MergedNdkConfig();

    public GradleVariantConfiguration(@NonNull ProductFlavorDsl defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildTypeDsl buildType, @Nullable SourceProvider buildTypeSourceProvider, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, signingConfigOverride);
        this.computeNdkConfig();
    }

    public GradleVariantConfiguration(@NonNull ProductFlavorDsl defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildTypeDsl buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull VariantConfiguration.Type type, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, type, signingConfigOverride);
        this.computeNdkConfig();
    }

    public GradleVariantConfiguration(@NonNull ProductFlavorDsl defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull BuildTypeDsl buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull VariantConfiguration.Type type, @Nullable VariantConfiguration testedConfig, @Nullable SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, type, testedConfig, signingConfigOverride);
        this.computeNdkConfig();
    }

    @NonNull
    public VariantConfiguration addProductFlavor(@NonNull GroupableProductFlavorDsl productFlavor, @NonNull SourceProvider sourceProvider, @NonNull String dimensionName) {
        super.addProductFlavor((ProductFlavor)productFlavor, sourceProvider, dimensionName);
        this.computeNdkConfig();
        return this;
    }

    @NonNull
    public NdkConfig getNdkConfig() {
        return this.mMergedNdkConfig;
    }

    @Nullable
    public Set<String> getSupportedAbis() {
        return this.mMergedNdkConfig.getAbiFilters();
    }

    public boolean isMinifyEnabled() {
        VariantConfiguration.Type type = this.getType();
        return ((BuildTypeDsl)this.getBuildType()).isMinifyEnabled() && (type != VariantConfiguration.Type.TEST || this.getTestedConfig().getType() != VariantConfiguration.Type.LIBRARY);
    }

    public boolean getUseJack() {
        Boolean value = ((BuildTypeDsl)this.getBuildType()).getUseJack();
        if (value != null) {
            return value;
        }
        for (GroupableProductFlavorDsl productFlavorDsl : this.getProductFlavors()) {
            value = productFlavorDsl.getUseJack();
            if (value == null) continue;
            return value;
        }
        value = ((ProductFlavorDsl)this.getDefaultConfig()).getUseJack();
        if (value != null) {
            return value;
        }
        return false;
    }

    private void computeNdkConfig() {
        this.mMergedNdkConfig.reset();
        if (((ProductFlavorDsl)this.getDefaultConfig()).getNdkConfig() != null) {
            this.mMergedNdkConfig.append(((ProductFlavorDsl)this.getDefaultConfig()).getNdkConfig());
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            NdkConfig ndkConfig = ((GroupableProductFlavorDsl)flavors.get(i)).getNdkConfig();
            if (ndkConfig == null) continue;
            this.mMergedNdkConfig.append(ndkConfig);
        }
        if (((BuildTypeDsl)this.getBuildType()).getNdkConfig() != null && this.getType() != VariantConfiguration.Type.TEST) {
            this.mMergedNdkConfig.append(((BuildTypeDsl)this.getBuildType()).getNdkConfig());
        }
    }
}

