/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ApplicationVariant;
import com.android.builder.AndroidDependency;
import com.android.builder.BundleDependency;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.diagnostics.internal.GraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.logging.StyledTextOutput;
import org.gradle.util.GUtil;

public class AndroidAsciiReportRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startVariant(final ApplicationVariant variant) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variant.getName());
                AndroidAsciiReportRenderer.this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)"");
            }
        }, true);
    }

    private String getDescription(Configuration configuration) {
        return GUtil.isTrue((Object)configuration.getDescription()) ? " - " + configuration.getDescription() : "";
    }

    public void completeConfiguration(ApplicationVariant variant) {
    }

    public void render(ApplicationVariant variant) throws IOException {
        List libraries = variant.getVariantConfiguration().getDirectLibraries();
        this.renderNow(libraries);
    }

    void renderNow(List<AndroidDependency> libraries) {
        if (libraries.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)"No dependencies");
            this.getTextOutput().println();
            return;
        }
        this.renderChildren(libraries);
    }

    public void complete() throws IOException {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(final AndroidDependency lib, boolean lastChild) {
        this.renderer.visit((Action)new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput styledTextOutput) {
                AndroidAsciiReportRenderer.this.getTextOutput().text((Object)((BundleDependency)lib).getName());
            }
        }, lastChild);
        this.renderChildren(lib.getDependencies());
    }

    private void renderChildren(List<AndroidDependency> libraries) {
        this.renderer.startChildren();
        for (int i = 0; i < libraries.size(); ++i) {
            AndroidDependency lib = libraries.get(i);
            this.render(lib, i == libraries.size() - 1);
        }
        this.renderer.completeChildren();
    }
}

