/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidSourceDirectory;
import com.android.build.gradle.AndroidSourceFile;
import com.android.build.gradle.AndroidSourceSet;
import com.android.build.gradle.internal.DefaultAndroidSourceDirectory;
import com.android.build.gradle.internal.DefaultAndroidSourceFile;
import com.android.builder.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.specs.Spec;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final String name;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectory assets;
    private final AndroidSourceDirectory res;
    private final AndroidSourceDirectory aidl;
    private final AndroidSourceDirectory renderscript;
    private final AndroidSourceDirectory jni;
    private final String displayName;
    private final SourceDirectorySet allSource;

    public DefaultAndroidSourceSet(String name, FileResolver fileResolver) {
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String javaResourcesDisplayName = String.format("%s Java resources", this.displayName);
        this.javaResources = new DefaultSourceDirectorySet(javaResourcesDisplayName, fileResolver);
        this.javaResources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultAndroidSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = String.format("%s source", this.displayName);
        this.allSource = new DefaultSourceDirectorySet(allSourceDisplayName, fileResolver);
        this.allSource.source(this.javaResources);
        this.allSource.source(this.javaSource);
        String manifestDisplayName = String.format("%s manifest", this.displayName);
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, fileResolver);
        String assetsDisplayName = String.format("%s assets", this.displayName);
        this.assets = new DefaultAndroidSourceDirectory(assetsDisplayName, fileResolver);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.res = new DefaultAndroidSourceDirectory(resourcesDisplayName, fileResolver);
        String aidlDisplayName = String.format("%s aidl", this.displayName);
        this.aidl = new DefaultAndroidSourceDirectory(aidlDisplayName, fileResolver);
        String renderscriptDisplayName = String.format("%s renderscript", this.displayName);
        this.renderscript = new DefaultAndroidSourceDirectory(renderscriptDisplayName, fileResolver);
        String jniDisplayName = String.format("%s jni", this.displayName);
        this.jni = new DefaultAndroidSourceDirectory(jniDisplayName, fileResolver);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("source set %s", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return String.format("%sCompile", this.name);
    }

    @Override
    public String getPackageConfigurationName() {
        if (this.name.equals("main")) {
            return "package";
        }
        return String.format("%sPackage", this.name);
    }

    @Override
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    public AndroidSourceDirectory getRes() {
        return this.res;
    }

    @Override
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    public AndroidSourceDirectory getAssets() {
        return this.assets;
    }

    @Override
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    public AndroidSourceDirectory getAidl() {
        return this.aidl;
    }

    @Override
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    public AndroidSourceDirectory getRenderscript() {
        return this.renderscript;
    }

    @Override
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    public AndroidSourceDirectory getJni() {
        return this.jni;
    }

    @Override
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    public SourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }

    public File getManifestFile() {
        return this.getManifest().getFile();
    }

    public File getAidlDir() {
        return this.getAidl().getDirectory();
    }

    public File getRenderscriptDir() {
        return this.getRenderscript().getDirectory();
    }

    public File getJniDir() {
        return this.getJni().getDirectory();
    }

    public File getResourcesDir() {
        return this.getRes().getDirectory();
    }

    public File getAssetsDir() {
        return this.getAssets().getDirectory();
    }
}

