/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidSourceDirectorySet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.file.FileResolver;

public class DefaultAndroidSourceDirectorySet
implements AndroidSourceDirectorySet {
    private final String name;
    private final FileResolver fileResolver;
    private List<Object> source = Lists.newArrayList();

    DefaultAndroidSourceDirectorySet(String name, FileResolver fileResolver) {
        this.name = name;
        this.fileResolver = fileResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AndroidSourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public AndroidSourceDirectorySet srcDirs(Object ... srcDirs) {
        Collections.addAll(this.source, srcDirs);
        return this;
    }

    @Override
    public AndroidSourceDirectorySet setSrcDirs(Iterable<?> srcDirs) {
        this.source.clear();
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    @Override
    public Set<File> getDirectories() {
        return this.fileResolver.resolveFiles(this.source.toArray()).getFiles();
    }

    public String toString() {
        return this.source.toString();
    }
}

