/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidSourceDirectorySet;
import com.android.build.gradle.AndroidSourceFile;
import com.android.build.gradle.AndroidSourceSet;
import com.android.build.gradle.internal.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.DefaultAndroidSourceFile;
import com.android.builder.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.specs.Spec;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final String name;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final String displayName;
    private final SourceDirectorySet allSource;

    public DefaultAndroidSourceSet(String name, FileResolver fileResolver) {
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String javaResourcesDisplayName = String.format("%s Java resources", this.displayName);
        this.javaResources = new DefaultSourceDirectorySet(javaResourcesDisplayName, fileResolver);
        this.javaResources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultAndroidSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = String.format("%s source", this.displayName);
        this.allSource = new DefaultSourceDirectorySet(allSourceDisplayName, fileResolver);
        this.allSource.source(this.javaResources);
        this.allSource.source(this.javaSource);
        String manifestDisplayName = String.format("%s manifest", this.displayName);
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, fileResolver);
        String assetsDisplayName = String.format("%s assets", this.displayName);
        this.assets = new DefaultAndroidSourceDirectorySet(assetsDisplayName, fileResolver);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.res = new DefaultAndroidSourceDirectorySet(resourcesDisplayName, fileResolver);
        String aidlDisplayName = String.format("%s aidl", this.displayName);
        this.aidl = new DefaultAndroidSourceDirectorySet(aidlDisplayName, fileResolver);
        String renderscriptDisplayName = String.format("%s renderscript", this.displayName);
        this.renderscript = new DefaultAndroidSourceDirectorySet(renderscriptDisplayName, fileResolver);
        String jniDisplayName = String.format("%s jni", this.displayName);
        this.jni = new DefaultAndroidSourceDirectorySet(jniDisplayName, fileResolver);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("source set %s", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return String.format("%sCompile", this.name);
    }

    @Override
    public String getPackageConfigurationName() {
        if (this.name.equals("main")) {
            return "package";
        }
        return String.format("%sPackage", this.name);
    }

    @Override
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @Override
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @Override
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @Override
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @Override
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @Override
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    public SourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }

    @Override
    public AndroidSourceSet setRoot(String path) {
        this.javaSource.setSrcDirs(Collections.singletonList(path + "/java"));
        this.javaResources.setSrcDirs(Collections.singletonList(path + "/resources"));
        this.res.setSrcDirs(Collections.singletonList(path + "/" + "res"));
        this.assets.setSrcDirs(Collections.singletonList(path + "/" + "assets"));
        this.manifest.srcFile(path + "/" + "AndroidManifest.xml");
        this.aidl.setSrcDirs(Collections.singletonList(path + "/aidl"));
        this.renderscript.setSrcDirs(Collections.singletonList(path + "/rs"));
        this.jni.setSrcDirs(Collections.singletonList(path + "jni"));
        return this;
    }

    public File getManifestFile() {
        return this.getManifest().getFile();
    }

    public Set<File> getAidlDirectories() {
        return this.getAidl().getDirectories();
    }

    public Set<File> getRenderscriptDirectories() {
        return this.getRenderscript().getDirectories();
    }

    public Set<File> getJniDirectories() {
        return this.getJni().getDirectories();
    }

    public Set<File> getResourcesDirectories() {
        return this.getRes().getDirectories();
    }

    public Set<File> getAssetsDirectories() {
        return this.getAssets().getDirectories();
    }
}

