/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.report.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.reporting.CodePanelRenderer;
import org.w3c.dom.Element;

class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();

    ClassPageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected String getTitle() {
        return ((ClassTestResults)((Object)this.getModel())).getTitle();
    }

    @Override
    protected void renderBreadcrumbs(Element parent) {
        Element div = this.append(parent, "div");
        div.setAttribute("class", "breadcrumbs");
        this.appendLink(div, "index.html", "all");
        this.appendText(div, " > ");
        this.appendLink(div, String.format("%s.html", ((ClassTestResults)((Object)this.getResults())).getPackageResults().getFilename(this.reportType)), ((ClassTestResults)((Object)this.getResults())).getPackageResults().getName());
        this.appendText(div, String.format(" > %s", ((ClassTestResults)((Object)this.getResults())).getSimpleName()));
    }

    private void renderTests(Element parent) {
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        Map<String, Map<String, TestResult>> results = ((ClassTestResults)((Object)this.getResults())).getTestResultsMap();
        ArrayList devices = Lists.newArrayList(results.keySet());
        Collections.sort(devices);
        this.appendWithText(tr, "th", "Test");
        for (String device : devices) {
            this.appendWithText(tr, "th", device);
        }
        HashSet tests = Sets.newHashSet();
        for (Map<String, TestResult> deviceMap : results.values()) {
            tests.addAll(deviceMap.keySet());
        }
        ArrayList sortedTests = Lists.newArrayList((Iterable)tests);
        Collections.sort(sortedTests);
        for (String testName : sortedTests) {
            tr = this.append(table, "tr");
            Element td = this.appendWithText(tr, "td", testName);
            TestResult.ResultType currentType = TestResult.ResultType.SKIPPED;
            for (String device : devices) {
                Map<String, TestResult> deviceMap = results.get(device);
                TestResult test = deviceMap.get(testName);
                Element deviceTd = this.appendWithText(tr, "td", String.format("%s (%s)", test.getFormattedResultType(), test.getFormattedDuration()));
                deviceTd.setAttribute("class", test.getStatusClass());
                currentType = ClassPageRenderer.combineResultType(currentType, test.getResultType());
            }
            td.setAttribute("class", this.getStatusClass(currentType));
        }
    }

    public static TestResult.ResultType combineResultType(TestResult.ResultType currentType, TestResult.ResultType newType) {
        switch (currentType) {
            case SUCCESS: {
                if (newType == TestResult.ResultType.FAILURE) {
                    return newType;
                }
                return currentType;
            }
            case FAILURE: {
                return currentType;
            }
            case SKIPPED: {
                if (newType != TestResult.ResultType.SKIPPED) {
                    return newType;
                }
                return currentType;
            }
        }
        throw new IllegalStateException();
    }

    public String getStatusClass(TestResult.ResultType resultType) {
        switch (resultType) {
            case SUCCESS: {
                return "success";
            }
            case FAILURE: {
                return "failures";
            }
            case SKIPPED: {
                return "skipped";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void renderFailures(Element parent) {
        Map<String, Map<String, TestResult>> results = ((ClassTestResults)((Object)this.getResults())).getTestResultsMap();
        HashMap testPassPercent = Maps.newHashMap();
        for (TestResult test : ((ClassTestResults)((Object)this.getResults())).getFailures()) {
            String testName = test.getName();
            TestPercent percent = (TestPercent)testPassPercent.get(testName);
            if (percent != null && percent.isFullFailure()) continue;
            if (percent == null) {
                int failed = 0;
                int total = 0;
                for (Map<String, TestResult> deviceMap : results.values()) {
                    TestResult.ResultType resultType = deviceMap.get(testName).getResultType();
                    if (resultType == TestResult.ResultType.FAILURE) {
                        ++failed;
                    }
                    if (resultType == TestResult.ResultType.SKIPPED) continue;
                    ++total;
                }
                percent = new TestPercent(failed, total);
                testPassPercent.put(testName, percent);
            }
            Element div = this.append(parent, "div");
            div.setAttribute("class", "test");
            this.append(div, "a").setAttribute("name", test.getId().toString());
            String name = percent.total == 1 ? testName : (percent.isFullFailure() ? testName + " [all devices]" : String.format("%s [%s] (on %d/%d devices)", testName, test.getDevice(), percent.failed, percent.total));
            this.appendWithText(div, "h3", name).setAttribute("class", test.getStatusClass());
            for (TestFailure failure : test.getFailures()) {
                this.codePanelRenderer.render(failure.getStackTrace(), div);
            }
        }
    }

    private void renderStdOut(Element parent) {
        this.codePanelRenderer.render(((Object)((ClassTestResults)((Object)this.getResults())).getStandardOutput()).toString(), parent);
    }

    private void renderStdErr(Element parent) {
        this.codePanelRenderer.render(((Object)((ClassTestResults)((Object)this.getResults())).getStandardError()).toString(), parent);
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", new Action<Element>(){

            public void execute(Element element) {
                ClassPageRenderer.this.renderTests(element);
            }
        });
        if (((ClassTestResults)((Object)this.getResults())).getStandardOutput().length() > 0) {
            this.addTab("Standard output", new Action<Element>(){

                public void execute(Element element) {
                    ClassPageRenderer.this.renderStdOut(element);
                }
            });
        }
        if (((ClassTestResults)((Object)this.getResults())).getStandardError().length() > 0) {
            this.addTab("Standard error", new Action<Element>(){

                public void execute(Element element) {
                    ClassPageRenderer.this.renderStdErr(element);
                }
            });
        }
        this.addDeviceAndVariantTabs();
    }

    private static final class TestPercent {
        int failed;
        int total;

        TestPercent(int failed, int total) {
            this.failed = failed;
            this.total = total;
        }

        boolean isFullFailure() {
            return this.failed == this.total;
        }
    }
}

