/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import org.gradle.api.Action;
import org.w3c.dom.Element;

class OverviewPageRenderer
extends PageRenderer<AllTestResults> {
    public OverviewPageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        if (!((AllTestResults)((Object)this.getResults())).getPackages().isEmpty()) {
            this.addTab("Packages", new Action<Element>(){

                public void execute(Element element) {
                    OverviewPageRenderer.this.renderPackages(element);
                }
            });
        }
        this.addTab("Classes", new Action<Element>(){

            public void execute(Element element) {
                OverviewPageRenderer.this.renderClasses(element);
            }
        });
        this.addDeviceAndVariantTabs();
    }

    @Override
    protected void renderBreadcrumbs(Element element) {
    }

    private void renderPackages(Element parent) {
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        this.appendWithText(tr, "th", "Package");
        this.appendWithText(tr, "th", "Tests");
        this.appendWithText(tr, "th", "Failures");
        this.appendWithText(tr, "th", "Duration");
        this.appendWithText(tr, "th", "Success rate");
        for (PackageTestResults testPackage : ((AllTestResults)((Object)this.getResults())).getPackages()) {
            tr = this.append(table, "tr");
            Element td = this.append(tr, "td");
            td.setAttribute("class", testPackage.getStatusClass());
            this.appendLink(td, String.format("%s.html", testPackage.getFilename(this.reportType)), testPackage.getName());
            this.appendWithText(tr, "td", testPackage.getTestCount());
            this.appendWithText(tr, "td", testPackage.getFailureCount());
            this.appendWithText(tr, "td", testPackage.getFormattedDuration());
            td = this.appendWithText(tr, "td", testPackage.getFormattedSuccessRate());
            td.setAttribute("class", testPackage.getStatusClass());
        }
    }

    private void renderClasses(Element parent) {
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        this.appendWithText(tr, "th", "Class");
        this.appendWithText(tr, "th", "Tests");
        this.appendWithText(tr, "th", "Failures");
        this.appendWithText(tr, "th", "Duration");
        this.appendWithText(tr, "th", "Success rate");
        for (PackageTestResults testPackage : ((AllTestResults)((Object)this.getResults())).getPackages()) {
            for (ClassTestResults testClass : testPackage.getClasses()) {
                tr = this.append(table, "tr");
                Element td = this.append(tr, "td");
                td.setAttribute("class", testClass.getStatusClass());
                this.appendLink(td, String.format("%s.html", testClass.getFilename(this.reportType)), testClass.getName());
                this.appendWithText(tr, "td", testClass.getTestCount());
                this.appendWithText(tr, "td", testClass.getFailureCount());
                this.appendWithText(tr, "td", testClass.getFormattedDuration());
                td = this.appendWithText(tr, "td", testClass.getFormattedSuccessRate());
                td.setAttribute("class", testClass.getStatusClass());
            }
        }
    }
}

