/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import org.gradle.api.Action;
import org.w3c.dom.Element;

public class PackagePageRenderer
extends PageRenderer<PackageTestResults> {
    public PackagePageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected String getTitle() {
        return ((PackageTestResults)((Object)this.getModel())).getTitle();
    }

    @Override
    protected void renderBreadcrumbs(Element parent) {
        Element div = this.append(parent, "div");
        div.setAttribute("class", "breadcrumbs");
        this.appendLink(div, "index.html", "all");
        this.appendText(div, String.format(" > %s", ((PackageTestResults)((Object)this.getResults())).getName()));
    }

    private void renderClasses(Element parent) {
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        this.appendWithText(tr, "th", "Class");
        this.appendWithText(tr, "th", "Tests");
        this.appendWithText(tr, "th", "Failures");
        this.appendWithText(tr, "th", "Duration");
        this.appendWithText(tr, "th", "Success rate");
        for (ClassTestResults testClass : ((PackageTestResults)((Object)this.getResults())).getClasses()) {
            tr = this.append(table, "tr");
            Element td = this.append(tr, "td");
            td.setAttribute("class", testClass.getStatusClass());
            this.appendLink(td, String.format("%s.html", testClass.getFilename(this.reportType)), testClass.getSimpleName());
            this.appendWithText(tr, "td", testClass.getTestCount());
            this.appendWithText(tr, "td", testClass.getFailureCount());
            this.appendWithText(tr, "td", testClass.getFormattedDuration());
            td = this.appendWithText(tr, "td", testClass.getFormattedSuccessRate());
            td.setAttribute("class", testClass.getStatusClass());
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Classes", new Action<Element>(){

            public void execute(Element element) {
                PackagePageRenderer.this.renderClasses(element);
            }
        });
        this.addDeviceAndVariantTabs();
    }
}

