/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestResult;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.report.TestResultModel;
import org.gradle.reporting.DomReportRenderer;
import org.gradle.reporting.TabbedPageRenderer;
import org.gradle.reporting.TabsRenderer;
import org.w3c.dom.Element;

abstract class PageRenderer<T extends CompositeTestResults>
extends TabbedPageRenderer<T> {
    private T results;
    private final TabsRenderer<T> tabsRenderer = new TabsRenderer();
    protected final ReportType reportType;

    PageRenderer(ReportType reportType) {
        this.reportType = reportType;
    }

    protected T getResults() {
        return this.results;
    }

    protected abstract void renderBreadcrumbs(Element var1);

    protected abstract void registerTabs();

    protected void addTab(String title, final Action<Element> contentRenderer) {
        this.tabsRenderer.add(title, new DomReportRenderer<T>(){

            public void render(T model, Element parent) {
                contentRenderer.execute((Object)parent);
            }
        });
    }

    protected void renderTabs(Element element) {
        this.tabsRenderer.render(this.getModel(), element);
    }

    protected void addFailuresTab() {
        if (!((CompositeTestResults)((Object)this.results)).getFailures().isEmpty()) {
            this.addTab("Failed tests", new Action<Element>(){

                public void execute(Element element) {
                    PageRenderer.this.renderFailures(element);
                }
            });
        }
    }

    protected void addDeviceAndVariantTabs() {
        if (((CompositeTestResults)((Object)this.results)).getResultsPerDevices().size() > 1) {
            this.addTab("Devices", new Action<Element>(){

                public void execute(Element element) {
                    PageRenderer.this.renderCompositeResults(element, PageRenderer.this.results.getResultsPerDevices(), "Devices");
                }
            });
        }
        if (((CompositeTestResults)((Object)this.results)).getResultsPerVariants().size() > 1) {
            this.addTab("Variants", new Action<Element>(){

                public void execute(Element element) {
                    PageRenderer.this.renderCompositeResults(element, PageRenderer.this.results.getResultsPerVariants(), "Variants");
                }
            });
        }
    }

    protected void renderFailures(Element parent) {
        Element ul = this.append(parent, "ul");
        ul.setAttribute("class", "linkList");
        boolean multiDevices = ((CompositeTestResults)((Object)this.results)).getResultsPerDevices().size() > 1;
        boolean multiVariants = ((CompositeTestResults)((Object)this.results)).getResultsPerVariants().size() > 1;
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        if (multiDevices) {
            this.appendWithText(tr, "th", "Devices");
        }
        if (multiVariants) {
            if (this.reportType == ReportType.MULTI_PROJECT) {
                this.appendWithText(tr, "th", "Project");
                this.appendWithText(tr, "th", "Flavor");
            } else if (this.reportType == ReportType.MULTI_FLAVOR) {
                this.appendWithText(tr, "th", "Flavor");
            }
        }
        this.appendWithText(tr, "th", "Class");
        this.appendWithText(tr, "th", "Test");
        for (TestResult test : ((CompositeTestResults)((Object)this.results)).getFailures()) {
            tr = this.append(table, "tr");
            if (multiDevices) {
                this.appendWithText(tr, "td", test.getDevice());
            }
            if (multiVariants) {
                if (this.reportType == ReportType.MULTI_PROJECT) {
                    this.appendWithText(tr, "td", test.getProject());
                    this.appendWithText(tr, "td", test.getFlavor());
                } else if (this.reportType == ReportType.MULTI_FLAVOR) {
                    this.appendWithText(tr, "td", test.getFlavor());
                }
            }
            Element td = this.append(tr, "td");
            this.appendLink(td, String.format("%s.html", test.getClassResults().getFilename(this.reportType)), test.getClassResults().getSimpleName());
            td = this.append(tr, "td");
            this.appendLink(td, String.format("%s.html#%s", test.getClassResults().getFilename(this.reportType), test.getName()), test.getName());
        }
    }

    protected void renderCompositeResults(Element parent, Map<String, ? extends CompositeTestResults> map, String name) {
        Element table = this.append(parent, "table");
        Element thead = this.append(table, "thead");
        Element tr = this.append(thead, "tr");
        this.appendWithText(tr, "th", name);
        this.appendWithText(tr, "th", "Tests");
        this.appendWithText(tr, "th", "Failures");
        this.appendWithText(tr, "th", "Duration");
        this.appendWithText(tr, "th", "Success rate");
        for (CompositeTestResults compositeTestResults : map.values()) {
            tr = this.append(table, "tr");
            Element td = this.appendWithText(tr, "td", compositeTestResults.getName());
            td.setAttribute("class", compositeTestResults.getStatusClass());
            this.appendWithText(tr, "td", compositeTestResults.getTestCount());
            this.appendWithText(tr, "td", compositeTestResults.getFailureCount());
            this.appendWithText(tr, "td", compositeTestResults.getFormattedDuration());
            td = this.appendWithText(tr, "td", compositeTestResults.getFormattedSuccessRate());
            td.setAttribute("class", compositeTestResults.getStatusClass());
        }
    }

    protected Element appendTableAndRow(Element parent) {
        return this.append(this.append(parent, "table"), "tr");
    }

    protected Element appendCell(Element parent) {
        return this.append(this.append(parent, "td"), "div");
    }

    protected <T extends TestResultModel> DomReportRenderer<T> withStatus(final DomReportRenderer<T> renderer) {
        return new DomReportRenderer<T>(){

            public void render(T model, Element parent) {
                parent.setAttribute("class", model.getStatusClass());
                renderer.render(model, parent);
            }
        };
    }

    protected String getTitle() {
        return ((CompositeTestResults)((Object)this.getModel())).getTitle();
    }

    protected String getPageTitle() {
        return String.format("Test results - %s", ((CompositeTestResults)((Object)this.getModel())).getTitle());
    }

    protected DomReportRenderer<T> getHeaderRenderer() {
        return new DomReportRenderer<T>(){

            public void render(T model, Element content) {
                PageRenderer.this.results = model;
                PageRenderer.this.renderBreadcrumbs(content);
                Element summary = this.appendWithId(content, "div", "summary");
                Element row = PageRenderer.this.appendTableAndRow(summary);
                Element group = PageRenderer.this.appendCell(row);
                group.setAttribute("class", "summaryGroup");
                Element summaryRow = PageRenderer.this.appendTableAndRow(group);
                Element tests = PageRenderer.this.appendCell(summaryRow);
                tests.setAttribute("id", "tests");
                tests.setAttribute("class", "infoBox");
                Element div = this.appendWithText(tests, "div", PageRenderer.this.results.getTestCount());
                div.setAttribute("class", "counter");
                this.appendWithText(tests, "p", "tests");
                Element failures = PageRenderer.this.appendCell(summaryRow);
                failures.setAttribute("id", "failures");
                failures.setAttribute("class", "infoBox");
                div = this.appendWithText(failures, "div", PageRenderer.this.results.getFailureCount());
                div.setAttribute("class", "counter");
                this.appendWithText(failures, "p", "failures");
                Element duration = PageRenderer.this.appendCell(summaryRow);
                duration.setAttribute("id", "duration");
                duration.setAttribute("class", "infoBox");
                div = this.appendWithText(duration, "div", PageRenderer.this.results.getFormattedDuration());
                div.setAttribute("class", "counter");
                this.appendWithText(duration, "p", "duration");
                Element successRate = PageRenderer.this.appendCell(row);
                successRate.setAttribute("id", "successRate");
                successRate.setAttribute("class", String.format("infoBox %s", PageRenderer.this.results.getStatusClass()));
                div = this.appendWithText(successRate, "div", PageRenderer.this.results.getFormattedSuccessRate());
                div.setAttribute("class", "percent");
                this.appendWithText(successRate, "p", "successful");
            }
        };
    }

    protected DomReportRenderer<T> getContentRenderer() {
        return new DomReportRenderer<T>(){

            public void render(T model, Element content) {
                PageRenderer.this.results = model;
                PageRenderer.this.tabsRenderer.clear();
                PageRenderer.this.registerTabs();
                PageRenderer.this.renderTabs(content);
            }
        };
    }
}

