/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dependency.ConfigurationDependencies;
import com.android.build.gradle.internal.dependency.LibraryDependencyImpl;
import com.android.build.gradle.internal.model.AndroidLibraryImpl;
import com.android.build.gradle.model.Dependencies;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.AndroidLibrary;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DependenciesImpl
implements Dependencies,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final List<AndroidLibrary> libraries;
    @NonNull
    private final List<File> jars;

    @NonNull
    static DependenciesImpl cloneConfigDependencies(@NonNull ConfigurationDependencies configDependencies) {
        List<LibraryDependencyImpl> libs = configDependencies.getLibraries();
        ArrayList libraries = Lists.newArrayListWithCapacity((int)libs.size());
        for (LibraryDependencyImpl libImpl : libs) {
            libraries.add(new AndroidLibraryImpl((LibraryDependency)libImpl, DependenciesImpl.getChildrenDependencies((LibraryDependency)libImpl)));
        }
        List<JarDependency> jarDeps = configDependencies.getJarDependencies();
        List<JarDependency> localDeps = configDependencies.getLocalDependencies();
        ArrayList jars = Lists.newArrayListWithCapacity((int)(jarDeps.size() + localDeps.size()));
        for (JarDependency jarDep : jarDeps) {
            jars.add(jarDep.getJarFile());
        }
        for (JarDependency jarDep : localDeps) {
            jars.add(jarDep.getJarFile());
        }
        return new DependenciesImpl(libraries, jars);
    }

    @NonNull
    private static List<AndroidLibraryImpl> getChildrenDependencies(LibraryDependency lib) {
        List children = lib.getDependencies();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)children.size());
        for (LibraryDependency child : children) {
            List<AndroidLibraryImpl> subResults = DependenciesImpl.getChildrenDependencies(child);
            result.add(new AndroidLibraryImpl(child, subResults));
        }
        return result;
    }

    private DependenciesImpl(@NonNull List<AndroidLibrary> libraries, @NonNull List<File> jars) {
        this.libraries = libraries;
        this.jars = jars;
    }

    @NonNull
    public List<AndroidLibrary> getLibraries() {
        return this.libraries;
    }

    @NonNull
    public List<File> getJars() {
        return this.jars;
    }

    @NonNull
    public List<String> getProjectDependenciesPath() {
        return Collections.emptyList();
    }
}

