/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceFile;
import com.android.builder.model.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.specs.Spec;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final String name;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final String displayName;
    private final SourceDirectorySet allSource;

    public DefaultAndroidSourceSet(String name, FileResolver fileResolver) {
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String javaResourcesDisplayName = String.format("%s Java resources", this.displayName);
        this.javaResources = new DefaultSourceDirectorySet(javaResourcesDisplayName, fileResolver);
        this.javaResources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultAndroidSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = String.format("%s source", this.displayName);
        this.allSource = new DefaultSourceDirectorySet(allSourceDisplayName, fileResolver);
        this.allSource.source(this.javaResources);
        this.allSource.source(this.javaSource);
        String manifestDisplayName = String.format("%s manifest", this.displayName);
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, fileResolver);
        String assetsDisplayName = String.format("%s assets", this.displayName);
        this.assets = new DefaultAndroidSourceDirectorySet(assetsDisplayName, fileResolver);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.res = new DefaultAndroidSourceDirectorySet(resourcesDisplayName, fileResolver);
        String aidlDisplayName = String.format("%s aidl", this.displayName);
        this.aidl = new DefaultAndroidSourceDirectorySet(aidlDisplayName, fileResolver);
        String renderscriptDisplayName = String.format("%s renderscript", this.displayName);
        this.renderscript = new DefaultAndroidSourceDirectorySet(renderscriptDisplayName, fileResolver);
        String jniDisplayName = String.format("%s jni", this.displayName);
        this.jni = new DefaultAndroidSourceDirectorySet(jniDisplayName, fileResolver);
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String toString() {
        return String.format("source set %s", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NonNull
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return String.format("%sCompile", this.name);
    }

    @Override
    @NonNull
    public String getPackageConfigurationName() {
        if (this.name.equals("main")) {
            return "package";
        }
        return String.format("%sPackage", this.name);
    }

    @Override
    @NonNull
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    @NonNull
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @Override
    @NonNull
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @Override
    @NonNull
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @Override
    @NonNull
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @Override
    @NonNull
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @Override
    @NonNull
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    @NonNull
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    @NonNull
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    @NonNull
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    @NonNull
    public SourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    @NonNull
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    @NonNull
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }

    @Override
    @NonNull
    public AndroidSourceSet setRoot(String path) {
        this.javaSource.setSrcDirs(Collections.singletonList(path + "/java"));
        this.javaResources.setSrcDirs(Collections.singletonList(path + "/resources"));
        this.res.setSrcDirs(Collections.singletonList(path + "/" + "res"));
        this.assets.setSrcDirs(Collections.singletonList(path + "/" + "assets"));
        this.manifest.srcFile(path + "/" + "AndroidManifest.xml");
        this.aidl.setSrcDirs(Collections.singletonList(path + "/aidl"));
        this.renderscript.setSrcDirs(Collections.singletonList(path + "/rs"));
        this.jni.setSrcDirs(Collections.singletonList(path + "/jni"));
        return this;
    }

    @NonNull
    public Set<File> getJavaDirectories() {
        return this.getJava().getSrcDirs();
    }

    @NonNull
    public Set<File> getResourcesDirectories() {
        return this.getResources().getSrcDirs();
    }

    @NonNull
    public File getManifestFile() {
        return this.getManifest().getSrcFile();
    }

    @NonNull
    public Set<File> getAidlDirectories() {
        return this.getAidl().getSrcDirs();
    }

    @NonNull
    public Set<File> getRenderscriptDirectories() {
        return this.getRenderscript().getSrcDirs();
    }

    @NonNull
    public Set<File> getJniDirectories() {
        return this.getJni().getSrcDirs();
    }

    @NonNull
    public Set<File> getResDirectories() {
        return this.getRes().getSrcDirs();
    }

    @NonNull
    public Set<File> getAssetsDirectories() {
        return this.getAssets().getSrcDirs();
    }
}

