/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.builder.DefaultBuildType;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;

public class TestVariantImpl
implements TestVariant {
    @NonNull
    private final TestVariantData variantData;
    @NonNull
    private BaseVariant testedVariant;

    public TestVariantImpl(@NonNull TestVariantData variantData) {
        this.variantData = variantData;
    }

    @Override
    @NonNull
    public String getName() {
        return this.variantData.getName();
    }

    @Override
    @NonNull
    public String getDescription() {
        return this.variantData.getDescription();
    }

    @Override
    @NonNull
    public String getDirName() {
        return this.variantData.getDirName();
    }

    @Override
    @NonNull
    public String getBaseName() {
        return this.variantData.getBaseName();
    }

    @Override
    @NonNull
    public DefaultBuildType getBuildType() {
        return this.variantData.getVariantConfiguration().getBuildType();
    }

    @Override
    @NonNull
    public List<DefaultProductFlavor> getProductFlavors() {
        return this.variantData.getVariantConfiguration().getFlavorConfigs();
    }

    @Override
    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.variantData.getVariantConfiguration().getMergedFlavor();
    }

    @Override
    @NonNull
    public File getOutputFile() {
        return this.variantData.getOutputFile();
    }

    @Override
    public void setOutputFile(@NonNull File outputFile) {
        if (this.variantData.zipAlignTask != null) {
            this.variantData.zipAlignTask.setOutputFile(outputFile);
        } else {
            this.variantData.packageApplicationTask.setOutputFile(outputFile);
        }
    }

    @Override
    @NonNull
    public BaseVariant getTestedVariant() {
        return this.testedVariant;
    }

    public void setTestedVariant(@NonNull BaseVariant testedVariant) {
        this.testedVariant = testedVariant;
    }

    @Override
    @NonNull
    public ProcessManifest getProcessManifest() {
        return this.variantData.processManifestTask;
    }

    @Override
    @NonNull
    public AidlCompile getAidlCompile() {
        return this.variantData.aidlCompileTask;
    }

    @Override
    @NonNull
    public RenderscriptCompile getRenderscriptCompile() {
        return this.variantData.renderscriptCompileTask;
    }

    @Override
    public MergeResources getMergeResources() {
        return this.variantData.mergeResourcesTask;
    }

    @Override
    public MergeAssets getMergeAssets() {
        return this.variantData.mergeAssetsTask;
    }

    @Override
    @NonNull
    public ProcessAndroidResources getProcessResources() {
        return this.variantData.processResourcesTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.variantData.generateBuildConfigTask;
    }

    @Override
    @NonNull
    public JavaCompile getJavaCompile() {
        return this.variantData.javaCompileTask;
    }

    @Override
    @NonNull
    public Copy getProcessJavaResources() {
        return this.variantData.processJavaResources;
    }

    @Override
    public Dex getDex() {
        return this.variantData.dexTask;
    }

    @Override
    public PackageApplication getPackageApplication() {
        return this.variantData.packageApplicationTask;
    }

    @Override
    public ZipAlign getZipAlign() {
        return this.variantData.zipAlignTask;
    }

    @Override
    public Task getAssemble() {
        return this.variantData.assembleTask;
    }

    @Override
    public DefaultTask getInstall() {
        return this.variantData.installTask;
    }

    @Override
    public DefaultTask getUninstall() {
        return this.variantData.uninstallTask;
    }

    @Override
    public DefaultTask getConnectedInstrumentTest() {
        return this.variantData.connectedTestTask;
    }

    @Override
    @NonNull
    public List<? extends DefaultTask> getProviderInstrumentTests() {
        return this.variantData.providerTestTaskList;
    }

    @Override
    public SigningConfig getSigningConfig() {
        return this.variantData.getVariantConfiguration().getSigningConfig();
    }

    @Override
    public boolean isSigningReady() {
        return this.variantData.isSigned();
    }
}

