/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.VariantConfiguration;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantData {
    private String name;
    private final VariantConfiguration variantConfiguration;
    private VariantDependencies variantDependency;
    public PrepareDependenciesTask prepareDependenciesTask;
    public ProcessManifest processManifestTask;
    public RenderscriptCompile renderscriptCompileTask;
    public AidlCompile aidlCompileTask;
    public MergeResources mergeResourcesTask;
    public MergeAssets mergeAssetsTask;
    public ProcessAndroidResources processResourcesTask;
    public GenerateBuildConfig generateBuildConfigTask;
    public JavaCompile javaCompileTask;
    public Copy processJavaResources;
    private Object outputFile;
    public Task assembleTask;

    public BaseVariantData(@NonNull VariantConfiguration variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
        this.name = this.computeName();
    }

    @NonNull
    protected abstract String computeName();

    @NonNull
    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantDependency(@NonNull VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    @NonNull
    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public abstract String getDescription();

    @NonNull
    public abstract String getDirName();

    @NonNull
    public String getFlavorDirName() {
        if (this.variantConfiguration.hasFlavors()) {
            return this.getFlavoredName(false);
        }
        return "";
    }

    @NonNull
    public String getFlavorName() {
        if (this.variantConfiguration.hasFlavors()) {
            return this.getFlavoredName(true);
        }
        return StringHelper.capitalize("main");
    }

    @NonNull
    public abstract String getBaseName();

    @Nullable
    public String getPackageName() {
        return this.variantConfiguration.getPackageName();
    }

    @NonNull
    protected String getFlavoredName(boolean capitalized) {
        StringBuilder builder = new StringBuilder();
        for (DefaultProductFlavor flavor : this.variantConfiguration.getFlavorConfigs()) {
            String name = flavor.getName();
            builder.append(capitalized ? StringHelper.capitalize(name) : name);
        }
        return builder.toString();
    }

    @NonNull
    protected String getCapitalizedBuildTypeName() {
        return StringHelper.capitalize(this.variantConfiguration.getBuildType().getName());
    }

    public boolean getRunProguard() {
        return false;
    }

    public void setOutputFile(Object file) {
        this.outputFile = file;
    }

    public File getOutputFile() {
        if (this.outputFile instanceof File) {
            return (File)this.outputFile;
        }
        if (this.outputFile instanceof Closure) {
            Closure c = (Closure)this.outputFile;
            return (File)c.call();
        }
        assert (false);
        return null;
    }
}

