/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.internal.LintGradleRequest;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LintGradleClient
extends LintCliClient {
    private final AndroidProject mModelProject;
    private final String mVariantName;
    private final BasePlugin mPlugin;
    private List<File> mCustomRules = Lists.newArrayList();

    public LintGradleClient(@NonNull IssueRegistry registry, @NonNull LintCliFlags flags, @NonNull BasePlugin plugin, @NonNull AndroidProject modelProject, @Nullable String variantName) {
        super(flags);
        this.mPlugin = plugin;
        this.mModelProject = modelProject;
        this.mVariantName = variantName;
        this.mRegistry = registry;
    }

    @NonNull
    public BasePlugin getPlugin() {
        return this.mPlugin;
    }

    public void setCustomRules(List<File> customRules) {
        this.mCustomRules = customRules;
    }

    public List<File> findRuleJars(@NonNull Project project) {
        return this.mCustomRules;
    }

    protected Project createProject(@NonNull File dir, @NonNull File referenceDir) {
        throw new IllegalStateException();
    }

    public File getSdkHome() {
        File sdkHome = this.mPlugin.getSdkDirectory();
        if (sdkHome != null) {
            return sdkHome;
        }
        return super.getSdkHome();
    }

    @NonNull
    protected LintRequest createLintRequest(@NonNull List<File> files) {
        return new LintGradleRequest(this, this.mModelProject, this.mPlugin, this.mVariantName, files);
    }

    @NonNull
    public List<Warning> run(@NonNull IssueRegistry registry) throws IOException {
        this.run(registry, Collections.emptyList());
        return this.mWarnings;
    }

    @NonNull
    public static List<Warning> merge(@NonNull Map<Variant, List<Warning>> warningMap, @NonNull AndroidProject project) {
        if (warningMap.size() == 1) {
            return warningMap.values().iterator().next();
        }
        int maxCount = 0;
        for (List<Warning> warnings : warningMap.values()) {
            int size = warnings.size();
            maxCount = Math.max(size, maxCount);
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        int totalVariantCount = project.getVariants().size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)(2 * maxCount));
        HashMap map = Maps.newHashMapWithExpectedSize((int)(2 * maxCount));
        for (Map.Entry<Variant, List<Warning>> entry : warningMap.entrySet()) {
            Variant variant = entry.getKey();
            List<Warning> warnings = entry.getValue();
            for (Warning warning : warnings) {
                String fileName;
                Warning canonical;
                Map fileMap;
                Map lineMap;
                Map messageMap = (Map)map.get(warning.issue);
                if (messageMap == null) {
                    messageMap = Maps.newHashMap();
                    map.put(warning.issue, messageMap);
                }
                if ((lineMap = (Map)messageMap.get(warning.message)) == null) {
                    lineMap = Maps.newHashMap();
                    messageMap.put(warning.message, lineMap);
                }
                if ((fileMap = (Map)lineMap.get(warning.line)) == null) {
                    fileMap = Maps.newHashMap();
                    lineMap.put(warning.line, fileMap);
                }
                if ((canonical = (Warning)fileMap.get(fileName = warning.file != null ? warning.file.getName() : "<unknown>")) == null) {
                    canonical = warning;
                    fileMap.put(fileName, canonical);
                    canonical.variants = Sets.newHashSet();
                    canonical.gradleProject = project;
                }
                merged.add(canonical);
                canonical.variants.add(variant);
            }
        }
        for (Warning warning : merged) {
            if (warning.variants == null || warning.variants.size() != totalVariantCount) continue;
            warning.variants = null;
        }
        Collections.sort(merged);
        return merged;
    }
}

