/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.LintGradleClient;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.client.api.LintClient;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.w3c.dom.Document;

public class LintGradleProject
extends com.android.tools.lint.detector.api.Project {
    private LintGradleProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull File manifest) {
        super((LintClient)client, dir, referenceDir);
        this.mGradleProject = true;
        this.mMergeManifests = true;
        this.mDirectLibraries = Lists.newArrayList();
        this.readManifest(manifest);
    }

    @NonNull
    public static Pair<LintGradleProject, List<File>> create(@NonNull LintGradleClient client, @NonNull AndroidProject project, @NonNull Variant variant, @NonNull Project gradleProject) {
        File dir = gradleProject.getRootDir();
        AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
        ArrayList customRules = Lists.newArrayList();
        File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
        if (appLintJar.exists()) {
            customRules.add(appLintJar);
        }
        HashSet libraries = Sets.newHashSet();
        Dependencies dependencies = variant.getMainArtifact().getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            lintProject.addDirectLibrary(LintGradleProject.createLibrary(client, library, libraries, customRules));
        }
        return Pair.of((Object)((Object)lintProject), (Object)customRules);
    }

    protected void initialize() {
    }

    protected void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document != null) {
                    this.readManifest(document);
                }
            }
            catch (IOException e) {
                this.mClient.log((Throwable)e, "Could not read manifest %1$s", new Object[]{manifest});
            }
        }
    }

    public boolean isGradleProject() {
        return true;
    }

    void addDirectLibrary(@NonNull com.android.tools.lint.detector.api.Project project) {
        this.mDirectLibraries.add(project);
    }

    @NonNull
    private static LibraryProject createLibrary(@NonNull LintGradleClient client, @NonNull AndroidLibrary library, @NonNull Set<AndroidLibrary> seen, List<File> customRules) {
        seen.add(library);
        File dir = library.getFolder();
        LibraryProject project = new LibraryProject(client, dir, dir, library);
        File ruleJar = library.getLintJar();
        if (ruleJar.exists()) {
            customRules.add(ruleJar);
        }
        for (AndroidLibrary dependent : library.getLibraryDependencies()) {
            if (seen.contains(dependent)) continue;
            project.addDirectLibrary(LintGradleProject.createLibrary(client, dependent, seen, customRules));
        }
        return project;
    }

    private static class LibraryProject
    extends LintGradleProject {
        private AndroidLibrary mLibrary;

        private LibraryProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidLibrary library) {
            super(client, dir, referenceDir, library.getManifest());
            this.mLibrary = library;
            this.mReportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public AndroidLibrary getGradleLibraryModel() {
            return this.mLibrary;
        }

        public Variant getCurrentVariant() {
            return null;
        }

        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifest = this.mLibrary.getManifest();
                this.mManifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                File proguardRules = this.mLibrary.getProguardRules();
                this.mProguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.mProguardFiles;
        }

        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                File folder = this.mLibrary.getResFolder();
                this.mResourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mResourceFolders;
        }

        @NonNull
        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        @NonNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @NonNull
        public List<File> getJavaLibraries() {
            if (this.mJavaLibraries == null) {
                File jarFile = this.mLibrary.getJarFile();
                this.mJavaLibraries = jarFile.exists() ? Collections.singletonList(jarFile) : Collections.emptyList();
            }
            return this.mJavaLibraries;
        }
    }

    private static class AppGradleProject
    extends LintGradleProject {
        private AndroidProject mProject;
        private Variant mVariant;
        private List<SourceProvider> mProviders;

        private AppGradleProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidProject project, @NonNull Variant variant) {
            super(client, dir, referenceDir, variant.getMainArtifact().getGeneratedManifest());
            this.mProject = project;
            this.mVariant = variant;
        }

        public boolean isLibrary() {
            return this.mProject.isLibrary();
        }

        public AndroidProject getGradleProjectModel() {
            return this.mProject;
        }

        public Variant getCurrentVariant() {
            return this.mVariant;
        }

        private List<SourceProvider> getSourceProviders() {
            if (this.mProviders == null) {
                SourceProvider variantProvider;
                ArrayList providers = Lists.newArrayList();
                AndroidArtifact mainArtifact = this.mVariant.getMainArtifact();
                providers.add(this.mProject.getDefaultConfig().getSourceProvider());
                block0: for (String flavorName : this.mVariant.getProductFlavors()) {
                    for (ProductFlavorContainer flavor : this.mProject.getProductFlavors()) {
                        if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                        providers.add(flavor.getSourceProvider());
                        continue block0;
                    }
                }
                SourceProvider multiProvider = mainArtifact.getMultiFlavorSourceProvider();
                if (multiProvider != null) {
                    providers.add(multiProvider);
                }
                String buildTypeName = this.mVariant.getBuildType();
                for (BuildTypeContainer buildType : this.mProject.getBuildTypes()) {
                    if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
                    providers.add(buildType.getSourceProvider());
                    break;
                }
                if ((variantProvider = mainArtifact.getVariantSourceProvider()) != null) {
                    providers.add(variantProvider);
                }
                this.mProviders = providers;
            }
            return this.mProviders;
        }

        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                this.mManifestFiles = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    File manifestFile = provider.getManifestFile();
                    if (!manifestFile.exists()) continue;
                    this.mManifestFiles.add(manifestFile);
                }
            }
            return this.mManifestFiles;
        }

        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                this.mProguardFiles = Lists.newArrayList();
                for (File file : flavor.getProguardFiles()) {
                    if (!file.exists()) continue;
                    this.mProguardFiles.add(file);
                }
                try {
                    for (File file : flavor.getConsumerProguardFiles()) {
                        if (!file.exists()) continue;
                        this.mProguardFiles.add(file);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.mProguardFiles;
        }

        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                this.mResourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection resDirs = provider.getResDirectories();
                    for (File res : resDirs) {
                        if (!res.exists()) continue;
                        this.mResourceFolders.add(res);
                    }
                }
            }
            return this.mResourceFolders;
        }

        @NonNull
        public List<File> getJavaSourceFolders() {
            if (this.mJavaSourceFolders == null) {
                this.mJavaSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection resDirs = provider.getJavaDirectories();
                    for (File res : resDirs) {
                        if (!res.exists()) continue;
                        this.mJavaSourceFolders.add(res);
                    }
                }
            }
            return this.mJavaSourceFolders;
        }

        @NonNull
        public List<File> getJavaClassFolders() {
            if (this.mJavaClassFolders == null) {
                this.mJavaClassFolders = new ArrayList(1);
                File outputClassFolder = this.mVariant.getMainArtifact().getClassesFolder();
                if (outputClassFolder.exists()) {
                    this.mJavaClassFolders.add(outputClassFolder);
                }
            }
            return this.mJavaClassFolders;
        }

        @NonNull
        public List<File> getJavaLibraries() {
            if (this.mJavaLibraries == null) {
                Collection jars = this.mVariant.getMainArtifact().getDependencies().getJars();
                this.mJavaLibraries = Lists.newArrayListWithExpectedSize((int)jars.size());
                for (File jar : jars) {
                    if (!jar.exists()) continue;
                    this.mJavaLibraries.add(jar);
                }
            }
            return this.mJavaLibraries;
        }

        @Nullable
        public String getPackage() {
            String packageName;
            if (this.mPackage == null && (packageName = this.mProject.getDefaultConfig().getProductFlavor().getPackageName()) != null) {
                return packageName;
            }
            return this.mPackage;
        }

        public int getMinSdk() {
            int minSdk = this.mProject.getDefaultConfig().getProductFlavor().getMinSdkVersion();
            if (minSdk != -1) {
                return minSdk;
            }
            return this.mMinSdk;
        }

        public int getTargetSdk() {
            int targetSdk = this.mProject.getDefaultConfig().getProductFlavor().getTargetSdkVersion();
            if (targetSdk != -1) {
                return targetSdk;
            }
            return targetSdk;
        }

        public int getBuildSdk() {
            String compileTarget = this.mProject.getCompileTarget();
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version != null) {
                return version.getApiLevel();
            }
            return super.getBuildSdk();
        }
    }
}

