/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.model.DefaultJavaCompileOptions;
import com.android.build.gradle.internal.model.VariantImpl;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.Variant;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;

class DefaultAndroidProject
implements AndroidProject,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String modelVersion;
    @NonNull
    private final String name;
    @NonNull
    private final String compileTarget;
    @NonNull
    private final Collection<String> bootClasspath;
    @NonNull
    private final Collection<File> frameworkSource;
    @NonNull
    private final Collection<SigningConfig> signingConfigs;
    @NonNull
    private final Collection<ArtifactMetaData> extraArtifacts;
    @NonNull
    private final Collection<String> unresolvedDependencies;
    @NonNull
    private final JavaCompileOptions javaCompileOptions;
    @NonNull
    private final LintOptions lintOptions;
    private final boolean isLibrary;
    private final Collection<BuildTypeContainer> buildTypes = Lists.newArrayList();
    private final Collection<ProductFlavorContainer> productFlavors = Lists.newArrayList();
    private final Collection<Variant> variants = Lists.newArrayList();
    private ProductFlavorContainer defaultConfig;

    DefaultAndroidProject(@NonNull String modelVersion, @NonNull String name, @NonNull String compileTarget, @NonNull Collection<String> bootClasspath, @NonNull Collection<File> frameworkSource, @NonNull Collection<SigningConfig> signingConfigs, @NonNull Collection<ArtifactMetaData> extraArtifacts, @NonNull Collection<String> unresolvedDependencies, @NonNull CompileOptions compileOptions, @NonNull LintOptions lintOptions, boolean isLibrary) {
        this.modelVersion = modelVersion;
        this.name = name;
        this.compileTarget = compileTarget;
        this.bootClasspath = bootClasspath;
        this.frameworkSource = frameworkSource;
        this.signingConfigs = signingConfigs;
        this.extraArtifacts = extraArtifacts;
        this.unresolvedDependencies = unresolvedDependencies;
        this.javaCompileOptions = new DefaultJavaCompileOptions(compileOptions);
        this.lintOptions = lintOptions;
        this.isLibrary = isLibrary;
    }

    @NonNull
    DefaultAndroidProject setDefaultConfig(@NonNull ProductFlavorContainer defaultConfigContainer) {
        this.defaultConfig = defaultConfigContainer;
        return this;
    }

    @NonNull
    DefaultAndroidProject addBuildType(@NonNull BuildTypeContainer buildTypeContainer) {
        this.buildTypes.add(buildTypeContainer);
        return this;
    }

    @NonNull
    DefaultAndroidProject addProductFlavors(@NonNull ProductFlavorContainer productFlavorContainer) {
        this.productFlavors.add(productFlavorContainer);
        return this;
    }

    @NonNull
    DefaultAndroidProject addVariant(@NonNull VariantImpl variant) {
        this.variants.add(variant);
        return this;
    }

    @NonNull
    public String getModelVersion() {
        return this.modelVersion;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ProductFlavorContainer getDefaultConfig() {
        return this.defaultConfig;
    }

    @NonNull
    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.buildTypes;
    }

    @NonNull
    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Collection<Variant> getVariants() {
        return this.variants;
    }

    @NonNull
    public Collection<ArtifactMetaData> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    public boolean isLibrary() {
        return this.isLibrary;
    }

    @NonNull
    public String getCompileTarget() {
        return this.compileTarget;
    }

    @NonNull
    public Collection<String> getBootClasspath() {
        return this.bootClasspath;
    }

    @NonNull
    public Collection<File> getFrameworkSources() {
        return this.frameworkSource;
    }

    @NonNull
    public Collection<SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    @NonNull
    public AaptOptions getAaptOptions() {
        return null;
    }

    @NonNull
    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    @NonNull
    public Collection<String> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    @NonNull
    public JavaCompileOptions getJavaCompileOptions() {
        return this.javaCompileOptions;
    }
}

