/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class SourceProviderContainerImpl
implements SourceProviderContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;
    @NonNull
    private final SourceProvider sourceProvider;

    @NonNull
    static SourceProviderContainer clone(@NonNull SourceProviderContainer sourceProviderContainer) {
        return SourceProviderContainerImpl.create(sourceProviderContainer.getArtifactName(), sourceProviderContainer.getSourceProvider());
    }

    @NonNull
    static List<SourceProviderContainer> cloneCollection(@NonNull Collection<SourceProviderContainer> containers) {
        ArrayList clones = Lists.newArrayListWithCapacity((int)containers.size());
        for (SourceProviderContainer container : containers) {
            clones.add(SourceProviderContainerImpl.clone(container));
        }
        return clones;
    }

    @NonNull
    static SourceProviderContainer create(@NonNull String name, @NonNull SourceProvider sourceProvider) {
        return new SourceProviderContainerImpl(name, SourceProviderImpl.cloneProvider(sourceProvider));
    }

    private SourceProviderContainerImpl(@NonNull String name, @NonNull SourceProvider sourceProvider) {
        this.name = name;
        this.sourceProvider = sourceProvider;
    }

    @NonNull
    public String getArtifactName() {
        return this.name;
    }

    @NonNull
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

