/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.html.SimpleHtmlWriter;
import org.gradle.internal.ErroringAction;

public class PackagePageRenderer
extends PageRenderer<PackageTestResults> {
    public PackagePageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected String getTitle() {
        return ((PackageTestResults)((Object)this.getModel())).getTitle();
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs");
        htmlWriter.startElement("a").attribute("href", "index.html").characters((CharSequence)"all").endElement();
        htmlWriter.characters((CharSequence)String.format(" > %s", ((PackageTestResults)((Object)this.getResults())).getName()));
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thread");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters((CharSequence)"Class").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        for (ClassTestResults testClass : ((PackageTestResults)((Object)this.getResults())).getClasses()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass());
            htmlWriter.startElement("a").attribute("href", String.format("%s.html", testClass.getFilename(this.reportType))).characters((CharSequence)testClass.getSimpleName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getTestCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)testClass.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters((CharSequence)testClass.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                PackagePageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }
}

