/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.StringHelper;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.MergeAssets;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.ProcessManifest;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.VariantConfiguration;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;
import proguard.gradle.ProGuardTask;

public abstract class BaseVariantData {
    private final VariantConfiguration variantConfiguration;
    private VariantDependencies variantDependency;
    public Task preBuildTask;
    public PrepareDependenciesTask prepareDependenciesTask;
    public Task sourceGenTask;
    public Task resourceGenTask;
    public CheckManifest checkManifestTask;
    public ProcessManifest processManifestTask;
    public RenderscriptCompile renderscriptCompileTask;
    public AidlCompile aidlCompileTask;
    public MergeResources mergeResourcesTask;
    public MergeAssets mergeAssetsTask;
    public ProcessAndroidResources processResourcesTask;
    public GenerateBuildConfig generateBuildConfigTask;
    public GenerateResValues generateResValuesTask;
    public JavaCompile javaCompileTask;
    public ProGuardTask proguardTask;
    public Copy processJavaResourcesTask;
    public NdkCompile ndkCompileTask;
    private Object outputFile;
    public Task assembleTask;
    private List<File> extraGeneratedSourceFolders;

    public BaseVariantData(@NonNull VariantConfiguration variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @NonNull
    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantDependency(@NonNull VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    @NonNull
    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    @NonNull
    public abstract String getDescription();

    @Nullable
    public String getPackageName() {
        return this.variantConfiguration.getPackageName();
    }

    @NonNull
    protected String getCapitalizedBuildTypeName() {
        return StringHelper.capitalize(this.variantConfiguration.getBuildType().getName());
    }

    @NonNull
    protected String getCapitalizedFlavorName() {
        return StringHelper.capitalize(this.variantConfiguration.getFlavorName());
    }

    public void setOutputFile(Object file) {
        this.outputFile = file;
    }

    public File getOutputFile() {
        if (this.outputFile instanceof File) {
            return (File)this.outputFile;
        }
        if (this.outputFile instanceof Closure) {
            Closure c = (Closure)this.outputFile;
            return (File)c.call();
        }
        assert (false);
        return null;
    }

    @NonNull
    String getName() {
        return this.variantConfiguration.getFullName();
    }

    @Nullable
    public List<File> getExtraGeneratedSourceFolders() {
        return this.extraGeneratedSourceFolders;
    }

    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        Collections.addAll(this.extraGeneratedSourceFolders, generatedSourceFolders);
    }

    public void addJavaSourceFoldersToModel(@NonNull Collection<File> generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        this.extraGeneratedSourceFolders.addAll(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(@NonNull Task task, File ... generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        this.javaCompileTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            this.javaCompileTask.source(new Object[]{f});
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(@NonNull Task task, @NonNull Collection<File> generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        this.javaCompileTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            this.javaCompileTask.source(new Object[]{f});
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }
}

