/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.VariantConfiguration;
import org.gradle.api.Task;

public class ApplicationVariantFactory
implements VariantFactory {
    @NonNull
    private final BasePlugin basePlugin;

    public ApplicationVariantFactory(@NonNull BasePlugin basePlugin) {
        this.basePlugin = basePlugin;
    }

    @Override
    @NonNull
    public BaseVariantData createVariantData(@NonNull VariantConfiguration variantConfiguration) {
        return new ApplicationVariantData(variantConfiguration);
    }

    @Override
    @NonNull
    public BaseVariant createVariantApi(@NonNull BaseVariantData variantData) {
        return (BaseVariant)this.basePlugin.getInstantiator().newInstance(ApplicationVariantImpl.class, new Object[]{variantData, this.basePlugin});
    }

    @Override
    @NonNull
    public VariantConfiguration.Type getVariantConfigurationType() {
        return VariantConfiguration.Type.DEFAULT;
    }

    @Override
    public boolean isVariantPublished() {
        return false;
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public void createTasks(@NonNull BaseVariantData variantData, @Nullable Task assembleTask) {
        assert (variantData instanceof ApplicationVariantData);
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantData;
        this.basePlugin.createAnchorTasks(variantData);
        this.basePlugin.createCheckManifestTask(variantData);
        this.basePlugin.createProcessManifestTask(variantData, "manifests");
        this.basePlugin.createGenerateResValuesTask(variantData);
        this.basePlugin.createRenderscriptTask(variantData);
        this.basePlugin.createMergeResourcesTask(variantData, true);
        this.basePlugin.createMergeAssetsTask(variantData, null, true);
        this.basePlugin.createBuildConfigTask(variantData);
        this.basePlugin.createProcessResTask(variantData, true);
        this.basePlugin.createProcessJavaResTask(variantData);
        this.basePlugin.createAidlTask(variantData);
        this.basePlugin.createCompileTask(variantData, null);
        this.basePlugin.createNdkTasks(variantData);
        this.basePlugin.addPackageTasks(appVariantData, assembleTask);
    }
}

