/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.api.GroupableProductFlavor;
import com.android.build.gradle.internal.StringHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProductFlavorCombo {
    private String name;
    @NonNull
    private final List<GroupableProductFlavor> flavorList;

    public ProductFlavorCombo(GroupableProductFlavor ... flavors) {
        this.flavorList = ImmutableList.copyOf((Object[])flavors);
    }

    public ProductFlavorCombo(@NonNull Iterable<GroupableProductFlavor> flavors) {
        this.flavorList = ImmutableList.copyOf(flavors);
    }

    @NonNull
    public String getName() {
        if (this.name == null) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (GroupableProductFlavor flavor : this.flavorList) {
                if (first) {
                    sb.append(flavor.getName());
                    first = false;
                    continue;
                }
                sb.append(StringHelper.capitalize(flavor.getName()));
            }
            this.name = sb.toString();
        }
        return this.name;
    }

    @NonNull
    public List<GroupableProductFlavor> getFlavorList() {
        return this.flavorList;
    }

    @NonNull
    public static List<ProductFlavorCombo> createCombinations(@Nullable List<String> flavorDimensions, @NonNull Iterable<? extends GroupableProductFlavor> productFlavors) {
        ArrayList result = Lists.newArrayList();
        if (flavorDimensions == null || flavorDimensions.isEmpty()) {
            for (GroupableProductFlavor groupableProductFlavor : productFlavors) {
                result.add(new ProductFlavorCombo((Iterable<GroupableProductFlavor>)ImmutableList.of((Object)groupableProductFlavor)));
            }
        } else {
            ArrayListMultimap map = ArrayListMultimap.create();
            for (GroupableProductFlavor groupableProductFlavor : productFlavors) {
                String flavorDimension = groupableProductFlavor.getFlavorDimension();
                if (flavorDimension == null) {
                    throw new RuntimeException(String.format("Flavor '%1$s' has no flavor dimension.", groupableProductFlavor.getName()));
                }
                if (!flavorDimensions.contains(flavorDimension)) {
                    throw new RuntimeException(String.format("Flavor '%1$s' has unknown dimension '%2$s'.", groupableProductFlavor.getName(), groupableProductFlavor.getFlavorDimension()));
                }
                map.put((Object)flavorDimension, (Object)groupableProductFlavor);
            }
            ProductFlavorCombo.createProductFlavorCombinations(result, new GroupableProductFlavor[flavorDimensions.size()], 0, flavorDimensions, (ListMultimap<String, GroupableProductFlavor>)map);
        }
        return result;
    }

    private static ImmutableList<GroupableProductFlavor> filterNullFromArray(GroupableProductFlavor[] flavors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (GroupableProductFlavor flavor : flavors) {
            if (flavor == null) continue;
            builder.add((Object)flavor);
        }
        return builder.build();
    }

    private static void createProductFlavorCombinations(List<ProductFlavorCombo> flavorGroups, GroupableProductFlavor[] group, int index, List<String> flavorDimensionList, ListMultimap<String, GroupableProductFlavor> map) {
        if (index == flavorDimensionList.size()) {
            flavorGroups.add(new ProductFlavorCombo((Iterable<GroupableProductFlavor>)ProductFlavorCombo.filterNullFromArray(group)));
            return;
        }
        String dimension = flavorDimensionList.get(index);
        List flavorList = map.get((Object)dimension);
        if (flavorList.isEmpty()) {
            throw new RuntimeException(String.format("No flavor is associated with flavor dimension '%1$s'.", dimension));
        }
        Iterator i$ = flavorList.iterator();
        while (i$.hasNext()) {
            GroupableProductFlavor flavor;
            group[index] = flavor = (GroupableProductFlavor)i$.next();
            ProductFlavorCombo.createProductFlavorCombinations(flavorGroups, group, index + 1, flavorDimensionList, map);
        }
    }
}

