/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.model.ApiVersion;
import com.android.builder.testing.TestData;
import com.android.ide.common.build.SplitOutputMatcher;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public class TestDataImpl
implements TestData {
    @NonNull
    private final TestVariantData testVariantData;
    @NonNull
    private final VariantConfiguration testVariantConfig;

    public TestDataImpl(@NonNull TestVariantData testVariantData) {
        this.testVariantData = testVariantData;
        this.testVariantConfig = testVariantData.getVariantConfiguration();
    }

    @NonNull
    public String getApplicationId() {
        return this.testVariantData.getApplicationId();
    }

    @Nullable
    public String getTestedApplicationId() {
        return this.testVariantConfig.getTestedApplicationId();
    }

    @NonNull
    public String getInstrumentationRunner() {
        return this.testVariantConfig.getInstrumentationRunner();
    }

    @NonNull
    public Boolean getHandleProfiling() {
        return this.testVariantConfig.getHandleProfiling();
    }

    @NonNull
    public Boolean getFunctionalTest() {
        return this.testVariantConfig.getFunctionalTest();
    }

    public boolean isTestCoverageEnabled() {
        return this.testVariantConfig.isTestCoverageEnabled();
    }

    @NonNull
    public ApiVersion getMinSdkVersion() {
        return this.testVariantConfig.getMinSdkVersion();
    }

    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        return testedVariantData2.getVariantConfiguration().getType() == VariantConfiguration.Type.LIBRARY;
    }

    @NonNull
    public ImmutableList<File> getTestedApks(int density, @NonNull List<String> abis) {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        BaseVariantData testedVariantData2 = (BaseVariantData)((Object)testedVariantData);
        List outputFiles = SplitOutputMatcher.computeBestOutput(testedVariantData2.getOutputs(), testedVariantData2.getVariantConfiguration().getSupportedAbis(), (int)density, abis);
        ImmutableList.Builder apks = ImmutableList.builder();
        for (OutputFile outputFile : outputFiles) {
            apks.add((Object)((ApkOutputFile)outputFile).getOutputFile());
        }
        return apks.build();
    }
}

