/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestedAndroidConfig;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.ApkVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.api.TestVariantImpl;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.api.UnitTestVariantImpl;
import com.android.build.gradle.internal.variant.ApplicationVariantFactory;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import org.gradle.internal.reflect.Instantiator;

public class ApiObjectFactory {
    @NonNull
    private final AndroidBuilder androidBuilder;
    @NonNull
    private final BaseExtension extension;
    @NonNull
    private final VariantFactory variantFactory;
    @NonNull
    private final Instantiator instantiator;
    @NonNull
    private final ReadOnlyObjectProvider readOnlyObjectProvider = new ReadOnlyObjectProvider();

    public ApiObjectFactory(@NonNull AndroidBuilder androidBuilder, @NonNull BaseExtension extension, @NonNull VariantFactory variantFactory, @NonNull Instantiator instantiator) {
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.variantFactory = variantFactory;
        this.instantiator = instantiator;
    }

    public void create(BaseVariantData<?> variantData) {
        if (variantData.getType().isForTesting()) {
            return;
        }
        BaseVariant variantApi = this.variantFactory.createVariantApi(variantData, this.readOnlyObjectProvider);
        if (this.variantFactory.hasTestScope()) {
            TestVariantData unitTestVariantData;
            TestVariantData androidTestVariantData = ((TestedVariantData)variantData).getTestVariantData(VariantType.ANDROID_TEST);
            if (androidTestVariantData != null) {
                TestVariantImpl androidTestVariant = (TestVariantImpl)this.instantiator.newInstance(TestVariantImpl.class, new Object[]{androidTestVariantData, variantApi, this.androidBuilder, this.readOnlyObjectProvider});
                ApplicationVariantFactory.createApkOutputApiObjects((Instantiator)this.instantiator, (BaseVariantData)androidTestVariantData, (ApkVariantImpl)androidTestVariant);
                ((TestedAndroidConfig)this.extension).getTestVariants().add((Object)androidTestVariant);
                ((TestedVariant)variantApi).setTestVariant((TestVariant)androidTestVariant);
            }
            if ((unitTestVariantData = ((TestedVariantData)variantData).getTestVariantData(VariantType.UNIT_TEST)) != null) {
                UnitTestVariantImpl unitTestVariant = (UnitTestVariantImpl)this.instantiator.newInstance(UnitTestVariantImpl.class, new Object[]{unitTestVariantData, variantApi, this.androidBuilder, this.readOnlyObjectProvider});
                ((TestedAndroidConfig)this.extension).getUnitTestVariants().add((Object)unitTestVariant);
                ((TestedVariant)variantApi).setUnitTestVariant((UnitTestVariant)unitTestVariant);
            }
        }
        this.extension.addVariant(variantApi);
    }
}

