/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.model.NativeLibraryImpl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.builder.model.NativeLibrary;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class NativeLibraryFactoryImpl
implements NativeLibraryFactory {
    @NonNull
    final NdkHandler ndkHandler;

    public NativeLibraryFactoryImpl(@NonNull NdkHandler ndkHandler) {
        this.ndkHandler = ndkHandler;
    }

    @NonNull
    public Optional<NativeLibrary> create(@NonNull VariantScope scope, @NonNull String toolchainName, @NonNull Abi abi) {
        BaseVariantData variantData = scope.getVariantData();
        if (!scope.getGlobalScope().getProject().hasProperty(NdkCompile.USE_DEPRECATED_NDK)) {
            return Optional.absent();
        }
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        String sysrootFlag = "--sysroot=" + this.ndkHandler.getSysroot(abi);
        ImmutableList cFlags = ndkConfig.getcFlags() == null ? ImmutableList.of((Object)sysrootFlag) : ImmutableList.of((Object)sysrootFlag, (Object)ndkConfig.getcFlags());
        return Optional.of((Object)new NativeLibraryImpl(ndkConfig.getModuleName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.ndkHandler.getStlIncludes(ndkConfig.getStl(), abi), Collections.emptyList(), Collections.emptyList(), (List)cFlags, (List)cFlags, (List)ImmutableList.of((Object)scope.getNdkDebuggableLibraryFolders(abi))));
    }
}

