/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import java.util.regex.Matcher;

public class PlaceholderEncoder {
    public void visit(@NonNull XmlDocument xmlDocument) {
        this.visit(xmlDocument.getRootNode());
    }

    private void visit(@NonNull XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            Matcher matcher = PlaceholderHandler.PATTERN.matcher(xmlAttribute.getValue());
            if (!matcher.matches()) continue;
            String encodedValue = "dollar_openBracket_" + matcher.group(2) + "_closeBracket";
            xmlAttribute.getXml().setValue(encodedValue);
        }
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            this.visit(childElement);
        }
    }
}

