/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.google.common.base.Objects;
import java.util.regex.Pattern;

public final class AndroidVersion
implements Comparable<AndroidVersion> {
    private final int mApiLevel;
    private final String mCodename;
    public static final AndroidVersion DEFAULT = new AndroidVersion(1, null);
    public static final AndroidVersion ART_RUNTIME = new AndroidVersion(21, null);
    public static final AndroidVersion BINDER_CMD_AVAILABLE = new AndroidVersion(24, null);
    public static final AndroidVersion ALLOW_SPLIT_APK_INSTALLATION = new AndroidVersion(21, null);
    public static final AndroidVersion SUPPORTS_MULTI_USER = new AndroidVersion(17, null);

    public AndroidVersion(int apiLevel, String codename) {
        this.mApiLevel = apiLevel;
        this.mCodename = AndroidVersion.sanitizeCodename(codename);
    }

    public AndroidVersion(String apiOrCodename) throws AndroidVersionException {
        String codename;
        int apiLevel;
        block3: {
            apiLevel = 0;
            codename = null;
            try {
                apiLevel = Integer.parseInt(apiOrCodename);
            }
            catch (NumberFormatException ignore) {
                if ("REL".equals(apiOrCodename) || !Pattern.matches("[A-Z_]+", apiOrCodename)) break block3;
                codename = apiOrCodename;
            }
        }
        this.mApiLevel = apiLevel;
        this.mCodename = AndroidVersion.sanitizeCodename(codename);
        if (this.mApiLevel <= 0 && codename == null) {
            throw new AndroidVersionException("Invalid android API or codename " + apiOrCodename, null);
        }
    }

    public int getApiLevel() {
        return this.mApiLevel;
    }

    public int getFeatureLevel() {
        return this.mCodename != null ? this.mApiLevel + 1 : this.mApiLevel;
    }

    public String getCodename() {
        return this.mCodename;
    }

    public String getApiString() {
        if (this.mCodename != null) {
            return this.mCodename;
        }
        return Integer.toString(this.mApiLevel);
    }

    public boolean isPreview() {
        return this.mCodename != null;
    }

    public boolean canRun(AndroidVersion appVersion) {
        if (appVersion.mCodename != null) {
            return appVersion.mCodename.equals(this.mCodename);
        }
        return this.mApiLevel >= appVersion.mApiLevel;
    }

    public boolean equals(int apiLevel) {
        return this.mCodename == null && apiLevel == this.mApiLevel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AndroidVersion)) {
            return false;
        }
        AndroidVersion other = (AndroidVersion)obj;
        return this.mApiLevel == other.mApiLevel && Objects.equal((Object)this.mCodename, (Object)other.mCodename);
    }

    public int hashCode() {
        if (this.mCodename != null) {
            return this.mCodename.hashCode();
        }
        return this.mApiLevel;
    }

    public String toString() {
        String s = String.format("API %1$d", this.mApiLevel);
        if (this.isPreview()) {
            s = s + String.format(", %1$s preview", this.mCodename);
        }
        return s;
    }

    @Override
    public int compareTo(AndroidVersion o) {
        return this.compareTo(o.mApiLevel, o.mCodename);
    }

    public int compareTo(int apiLevel, String codename) {
        if (this.mCodename == null) {
            if (codename == null) {
                return this.mApiLevel - apiLevel;
            }
            if (this.mApiLevel == apiLevel) {
                return -1;
            }
            return this.mApiLevel - apiLevel;
        }
        if (this.mApiLevel == apiLevel) {
            if (codename == null) {
                return 1;
            }
            return this.mCodename.compareTo(codename);
        }
        return this.mApiLevel - apiLevel;
    }

    public boolean isGreaterOrEqualThan(int api) {
        return this.compareTo(api, null) >= 0;
    }

    private static String sanitizeCodename(String codename) {
        if (codename != null && ((codename = codename.trim()).isEmpty() || "REL".equals(codename))) {
            codename = null;
        }
        return codename;
    }

    public static final class AndroidVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AndroidVersionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

