/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElement
extends UserDataHolder,
Iconable {
    public static final PsiElement[] EMPTY_ARRAY = new PsiElement[0];
    public static final ArrayFactory<PsiElement> ARRAY_FACTORY = new ArrayFactory<PsiElement>(){

        @NotNull
        public PsiElement[] create(int count) {
            PsiElement[] psiElementArray = count == 0 ? EMPTY_ARRAY : new PsiElement[count];
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElement$1", "create"));
            }
            return psiElementArray;
        }
    };

    @NotNull
    @Contract(pure=true)
    public Language getLanguage();

    @NotNull
    @Contract(pure=true)
    public PsiElement[] getChildren();

    @Contract(pure=true)
    public PsiElement getParent();

    @Contract(pure=true)
    public PsiElement getFirstChild();

    @Contract(pure=true)
    public PsiElement getLastChild();

    @Contract(pure=true)
    public PsiElement getNextSibling();

    @Contract(pure=true)
    public PsiElement getPrevSibling();

    @Contract(pure=true)
    public PsiFile getContainingFile() throws PsiInvalidElementAccessException;

    @Contract(pure=true)
    public TextRange getTextRange();

    @Contract(pure=true)
    public int getStartOffsetInParent();

    @Contract(pure=true)
    public int getTextLength();

    @Contract(pure=true)
    public int getTextOffset();

    @NonNls
    @Contract(pure=true)
    public String getText();

    @NotNull
    @Contract(pure=true)
    public char[] textToCharArray();

    @Contract(pure=true)
    public PsiElement getNavigationElement();

    @Contract(pure=true)
    public PsiElement getOriginalElement();

    @Contract(pure=true)
    public boolean textMatches(@NotNull @NonNls CharSequence var1);

    @Contract(pure=true)
    public boolean textMatches(@NotNull PsiElement var1);

    @Contract(pure=true)
    public boolean textContains(char var1);

    public void accept(@NotNull PsiElementVisitor var1);

    public void acceptChildren(@NotNull PsiElementVisitor var1);

    @Contract(pure=true)
    public boolean isValid();

    @Contract(pure=true)
    public boolean isWritable();

    @Nullable
    @Contract(pure=true)
    public PsiReference getReference();

    @NotNull
    @Contract(pure=true)
    public PsiReference[] getReferences();

    @Nullable
    @Contract(pure=true)
    public PsiElement getContext();

    @Contract(pure=true)
    public boolean isPhysical();

    @NonNls
    @Contract(pure=true)
    public String toString();
}

